/*
 * Decompiled with CFR 0.152.
 */
package de.eisi05.npc.api.objects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import de.eisi05.npc.api.utils.Reflections;
import de.eisi05.npc.api.utils.Versions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Skin(@Nullable String name, @NotNull String value, @NotNull String signature) implements Serializable
{
    private static final long serialVersionUID = 1L;
    private static final Map<UUID, Skin> skinCache = new HashMap<UUID, Skin>();

    @Nullable
    public static Skin fromPlayer(@NotNull Player player) {
        if (Versions.isCurrentVersionSmallerThan(Versions.V1_21_9)) {
            ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
            PropertyMap properties = (PropertyMap)Reflections.invokeMethod(serverPlayer.getGameProfile(), "getProperties", new Object[0]).get();
            Iterator it = properties.get((Object)"textures").iterator();
            if (!it.hasNext()) {
                return null;
            }
            Property property = (Property)it.next();
            return new Skin(player.getName(), property.value(), property.signature());
        }
        ServerPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Iterator properties = serverPlayer.getGameProfile().properties().get((Object)"textures").iterator();
        if (!properties.hasNext()) {
            return null;
        }
        Property property = (Property)properties.next();
        return new Skin(player.getName(), property.value(), property.signature());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Skin fetchSkin(@NotNull UUID uuid) {
        if (skinCache.containsKey(uuid)) {
            return skinCache.get(uuid);
        }
        try {
            URL url = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid) + "?unsigned=false").toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setReadTimeout(10000);
            try (InputStream is = connection.getInputStream();){
                Iterator iterator;
                Scanner scanner;
                block16: {
                    scanner = new Scanner(is);
                    try {
                        String response = scanner.useDelimiter("\\A").next();
                        JsonObject json = JsonParser.parseString((String)response).getAsJsonObject();
                        String name = json.get("name").getAsString();
                        JsonArray properties = json.getAsJsonArray("properties");
                        iterator = properties.iterator();
                        if (!iterator.hasNext()) break block16;
                        JsonElement prop = (JsonElement)iterator.next();
                        JsonObject obj = prop.getAsJsonObject();
                        String value = obj.get("value").getAsString();
                        String signature = obj.has("signature") ? obj.get("signature").getAsString() : null;
                        Skin skin = new Skin(name, value, signature);
                        skinCache.put(uuid, skin);
                        Skin skin2 = skin;
                        scanner.close();
                        return skin2;
                    }
                    catch (Throwable throwable) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                iterator = null;
                scanner.close();
                return iterator;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Skin fetchSkin(@NotNull String name) {
        try {
            URL url = URI.create("https://api.mojang.com/users/profiles/minecraft/" + name).toURL();
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setReadTimeout(10000);
            try (InputStream is = conn.getInputStream();){
                Scanner scanner = new Scanner(is);
                try {
                    String response = scanner.useDelimiter("\\A").next();
                    JsonObject json = JsonParser.parseString((String)response).getAsJsonObject();
                    String id = json.get("id").getAsString();
                    Skin skin = Skin.fetchSkin(UUID.fromString(id.replaceFirst("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5")));
                    scanner.close();
                    return skin;
                }
                catch (Throwable throwable) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Optional<Skin> fetchSkin(@NotNull File skinFile) {
        if (!skinFile.exists()) {
            throw new IllegalArgumentException("File does not exist");
        }
        HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
        try {
            String boundary = "----MineSkinBoundary" + System.currentTimeMillis();
            String CRLF = "\r\n";
            byte[] fileBytes = Files.readAllBytes(skinFile.toPath());
            String bodyBuilder = "--" + boundary + CRLF + "Content-Disposition: form-data; name=\"file\"; filename=\"" + skinFile.getName() + "\"" + CRLF + "Content-Type: image/png" + CRLF + CRLF;
            String endPart = CRLF + "--" + boundary + "--" + CRLF;
            byte[] requestBody = Skin.combine(bodyBuilder.getBytes(), fileBytes, endPart.getBytes());
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.mineskin.org/generate/upload")).timeout(Duration.ofSeconds(10L)).header("Content-Type", "multipart/form-data; boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofByteArray(requestBody)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            JsonObject obj = JsonParser.parseString((String)response.body()).getAsJsonObject();
            JsonObject texture = obj.getAsJsonObject("data").getAsJsonObject("texture");
            String value = texture.get("value").getAsString();
            String signature = texture.get("signature").getAsString();
            Optional<Skin> optional = Optional.of(new Skin(null, value, signature));
            if (client != null) {
                client.close();
            }
            return optional;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException | InterruptedException e) {
                return Optional.empty();
            }
        }
    }

    public static CompletableFuture<Skin> fetchSkinAsync(@NotNull UUID uuid) {
        return CompletableFuture.supplyAsync(() -> Skin.fetchSkin(uuid));
    }

    public static CompletableFuture<Skin> fetchSkinAsync(@NotNull String name) {
        return CompletableFuture.supplyAsync(() -> Skin.fetchSkin(name));
    }

    public static CompletableFuture<Optional<Skin>> fetchSkinAsync(@NotNull File skinFile) {
        return CompletableFuture.supplyAsync(() -> Skin.fetchSkin(skinFile));
    }

    private static byte[] combine(byte[] ... arrays) throws IOException {
        int length = 0;
        for (byte[] arr : arrays) {
            length += arr.length;
        }
        byte[] result = new byte[length];
        int pos = 0;
        for (byte[] arr : arrays) {
            System.arraycopy(arr, 0, result, pos, arr.length);
            pos += arr.length;
        }
        return result;
    }
}

