/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.client;

import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.veroxuniverse.samurai_dynasty.curios.model.KitsuneMaskModel;
import net.veroxuniverse.samurai_dynasty.curios.model.OniMaskModel;
import net.veroxuniverse.samurai_dynasty.item.armor.NetheriteSamuraiArmorItem;
import net.veroxuniverse.samurai_dynasty.item.armor.SteelSamuraiArmorItem;
import net.veroxuniverse.samurai_dynasty.particle.BlueFlame;
import net.veroxuniverse.samurai_dynasty.particle.ModParticles;
import net.veroxuniverse.samurai_dynasty.particle.SpiritBlossomLeaves;
import net.veroxuniverse.samurai_dynasty.particle.SpiritWoodLeaves;
import net.veroxuniverse.samurai_dynasty.registry.ItemsRegistry;

@EventBusSubscriber(modid="samurai_dynasty", value={Dist.CLIENT})
public class SamuraiDynastyClientMod {
    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.BLUE_FLAME.get(), BlueFlame.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.SPIRIT_WOOD_LEAVES.get(), SpiritWoodLeaves.Provider::new);
        Minecraft.getInstance().particleEngine.register((ParticleType)ModParticles.SPIRIT_BLOSSOM_LEAVES.get(), SpiritBlossomLeaves.Provider::new);
    }

    @SubscribeEvent
    public static void registerLayerRenderers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(OniMaskModel.LAYER_LOCATION, OniMaskModel::createBodyLayer);
        event.registerLayerDefinition(KitsuneMaskModel.LAYER_LOCATION, KitsuneMaskModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void itemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, color) -> color > 0 ? -1 : SteelSamuraiArmorItem.getColor(stack), new ItemLike[]{(ItemLike)ItemsRegistry.STEEL_SAMURAI_HELMET.get(), (ItemLike)ItemsRegistry.STEEL_SAMURAI_CHESTPLATE.get(), (ItemLike)ItemsRegistry.STEEL_SAMURAI_LEGGINGS.get(), (ItemLike)ItemsRegistry.STEEL_SAMURAI_BOOTS.get()});
        event.register((stack, color) -> color > 0 ? -1 : NetheriteSamuraiArmorItem.getColor(stack), new ItemLike[]{(ItemLike)ItemsRegistry.NETHERITE_SAMURAI_HELMET.get(), (ItemLike)ItemsRegistry.NETHERITE_SAMURAI_CHESTPLATE.get(), (ItemLike)ItemsRegistry.NETHERITE_SAMURAI_LEGGINGS.get(), (ItemLike)ItemsRegistry.NETHERITE_SAMURAI_BOOTS.get()});
    }
}

