/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.curios;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.veroxuniverse.samurai_dynasty.registry.ItemsRegistry;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class OniMaskCurios
extends Item
implements ICurioItem {
    public OniMaskCurios(Item.Properties pProperties) {
        super(pProperties);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
            player.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
        }
        if (player.hasEffect(MobEffects.WITHER)) {
            player.removeEffect(MobEffects.WITHER);
        }
        player.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 240, 0, false, false, false));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        if (Screen.hasShiftDown() && stack.getItem() == ItemsRegistry.ONI_MASK.get()) {
            components.add((Component)Component.translatable((String)"curios.samurai_dynasty.summary"));
            components.add((Component)Component.literal((String)""));
            components.add((Component)Component.translatable((String)"curios.samurai_dynasty.nightvision").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"curios.samurai_dynasty.immune_slowness").withStyle(ChatFormatting.GRAY));
            components.add((Component)Component.translatable((String)"curios.samurai_dynasty.immune_wither").withStyle(ChatFormatting.GRAY));
        } else if (stack.getItem() == ItemsRegistry.ONI_MASK.get()) {
            components.add((Component)Component.translatable((String)"curios.samurai_dynasty.summary"));
        }
        super.appendHoverText(stack, context, components, flag);
    }

    public boolean canEquip(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }
}

