/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.curios.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class OniMaskModel<T extends LivingEntity>
extends HumanoidModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"samurai_dynasty", (String)"oni_mask"), "main");
    public final ModelPart bipedArmorHead;

    public OniMaskModel(ModelPart root) {
        super(root);
        this.bipedArmorHead = root.getChild("bipedArmorHead");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bipedArmorHead = partdefinition.addOrReplaceChild("bipedArmorHead", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition armorHead = bipedArmorHead.addOrReplaceChild("armorHead", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mask = armorHead.addOrReplaceChild("mask", CubeListBuilder.create().texOffs(5, 5).addBox(-4.5f, -3.5f, -4.5f, 9.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition mask_r1 = mask.addOrReplaceChild("mask_r1", CubeListBuilder.create().texOffs(44, 25).addBox(-5.0f, -1.2f, -4.8f, 10.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition nose = mask.addOrReplaceChild("nose", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-4.3f, (float)-4.9f));
        PartDefinition nose_r1 = nose.addOrReplaceChild("nose_r1", CubeListBuilder.create().texOffs(0, 28).addBox(-1.0f, -1.0f, 0.0f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition jaw = mask.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(11, 26).addBox(-3.0f, -0.5f, -2.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(29, 26).addBox(-3.5f, -3.2f, -1.3f, 7.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.3f, (float)-3.7f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition hat = partdefinition.addOrReplaceChild("hat", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition body = partdefinition.addOrReplaceChild("body", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", new CubeListBuilder(), PartPose.ZERO);
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", new CubeListBuilder(), PartPose.ZERO);
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.bipedArmorHead.render(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    public void copyPropertiesTo(HumanoidModel<T> humanoidModel) {
        super.copyPropertiesTo(humanoidModel);
        this.bipedArmorHead.copyFrom(humanoidModel.head);
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.bipedArmorHead);
    }

    protected Iterable<ModelPart> bodyParts() {
        return null;
    }
}

