/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.veroxuniverse.samurai_dynasty.registry.BlocksRegistry;
import net.veroxuniverse.samurai_dynasty.registry.ItemsRegistry;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "samurai_dynasty", existingFileHelper);
    }

    protected void registerModels() {
        this.wallItem(BlocksRegistry.SPIRIT_STONE_WALL, BlocksRegistry.SPIRIT_STONE);
        this.wallItem(BlocksRegistry.POLISHED_SPIRIT_STONE_WALL, BlocksRegistry.POLISHED_SPIRIT_STONE);
        this.wallItem(BlocksRegistry.MOSSY_SPIRIT_STONE_BRICK_WALL, BlocksRegistry.MOSSY_SPIRIT_STONE_BRICKS);
        this.basicItem((Item)ItemsRegistry.LIGHT_SAMURAI_BOOTS.get());
        this.basicItem((Item)ItemsRegistry.LIGHT_SAMURAI_CHESTPLATE.get());
        this.basicItem((Item)ItemsRegistry.LIGHT_SAMURAI_LEGGINGS.get());
        this.basicItem((Item)ItemsRegistry.LIGHT_SAMURAI_HELMET.get());
        this.basicItem((Item)ItemsRegistry.MASTER_SAMURAI_BOOTS.get());
        this.basicItem((Item)ItemsRegistry.MASTER_SAMURAI_CHESTPLATE.get());
        this.basicItem((Item)ItemsRegistry.MASTER_SAMURAI_LEGGINGS.get());
        this.basicItem((Item)ItemsRegistry.MASTER_SAMURAI_HELMET.get());
        this.basicItem((Item)ItemsRegistry.CLOUD_BUCKET.get());
        this.buttonItem(BlocksRegistry.SPIRIT_BLOSSOM_BUTTON, BlocksRegistry.SPIRIT_BLOSSOM_PLANKS);
        this.fenceItem(BlocksRegistry.SPIRIT_BLOSSOM_FENCE, BlocksRegistry.SPIRIT_BLOSSOM_PLANKS);
        this.basicItem(BlocksRegistry.SPIRIT_BLOSSOM_DOOR.asItem());
        this.buttonItem(BlocksRegistry.SPIRIT_WOOD_BUTTON, BlocksRegistry.SPIRIT_WOOD_PLANKS);
        this.fenceItem(BlocksRegistry.SPIRIT_WOOD_FENCE, BlocksRegistry.SPIRIT_WOOD_PLANKS);
        this.basicItem(BlocksRegistry.SPIRIT_WOOD_DOOR.asItem());
        this.saplingItem(BlocksRegistry.SPIRIT_WOOD_SAPLING);
        this.saplingItem(BlocksRegistry.SPIRIT_BLOSSOM_SAPLING);
        this.saplingItem(BlocksRegistry.SPIDER_LILLY);
    }

    private ItemModelBuilder saplingItem(DeferredBlock<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"samurai_dynasty", (String)("block/" + item.getId().getPath())));
    }

    public void flowerItem(DeferredBlock<Block> block) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"samurai_dynasty", (String)("block/" + block.getId().getPath())));
    }

    public void buttonItem(DeferredBlock<Block> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/button_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"samurai_dynasty", (String)("block/" + baseBlock.getId().getPath())));
    }

    public void fenceItem(DeferredBlock<Block> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"samurai_dynasty", (String)("block/" + baseBlock.getId().getPath())));
    }

    public void wallItem(DeferredBlock<Block> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"samurai_dynasty", (String)("block/" + baseBlock.getId().getPath())));
    }
}

