/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.entity.custom;

import javax.annotation.Nullable;
import mod.azure.azurelib.common.util.MoveAnalysis;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.veroxuniverse.samurai_dynasty.client.entities.FujinDispatcher;
import net.veroxuniverse.samurai_dynasty.entity.goals.AnimatedMeleeAttackGoal;

public class FujinEntity
extends Monster
implements RangedAttackMob {
    public final FujinDispatcher dispatcher;
    public final MoveAnalysis moveAnalysis;
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS).setDarkenScreen(true);

    public FujinEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.dispatcher = new FujinDispatcher(this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 400.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ATTACK_SPEED, (double)0.3f).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.FLYING_SPEED, (double)0.6f).add(Attributes.ARMOR, 4.0).add(Attributes.MOVEMENT_SPEED, (double)0.2f).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, new AnimatedMeleeAttackGoal<FujinEntity>(this, 1.2, false, (entity, target) -> entity.dispatcher.attack()));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public void tick() {
        super.tick();
        this.moveAnalysis.update();
        if (this.level().isClientSide) {
            boolean isMovingOnGround;
            boolean bl = isMovingOnGround = this.moveAnalysis.isMovingHorizontally() && this.onGround();
            Runnable animationRunner = isMovingOnGround ? this.dispatcher::walk : this.dispatcher::idle;
            animationRunner.run();
        }
    }

    public void setCustomName(@Nullable Component component) {
        super.setCustomName(component);
        this.bossEvent.setName(this.getDisplayName());
    }

    public void startSeenByPlayer(ServerPlayer serverPlayer) {
        super.startSeenByPlayer(serverPlayer);
        this.bossEvent.addPlayer(serverPlayer);
    }

    public void stopSeenByPlayer(ServerPlayer serverPlayer) {
        super.stopSeenByPlayer(serverPlayer);
        this.bossEvent.removePlayer(serverPlayer);
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.discard();
        } else {
            this.noActionTime = 0;
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public int getCurrentSwingDuration() {
        return 18;
    }

    public void performRangedAttack(LivingEntity entity, float v) {
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.WITHER_AMBIENT;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.WITHER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WITHER_DEATH;
    }

    protected float getSoundVolume() {
        return 0.5f;
    }

    public float getVoicePitch() {
        return 0.5f;
    }
}

