/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.entity.custom;

import mod.azure.azurelib.common.util.MoveAnalysis;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.hoglin.HoglinBase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.veroxuniverse.samurai_dynasty.client.entities.KitsuneDispatcher;
import net.veroxuniverse.samurai_dynasty.entity.goals.AnimatedMeleeAttackGoal;
import net.veroxuniverse.samurai_dynasty.entity.goals.SpawnMobNearPlayerGoal;
import net.veroxuniverse.samurai_dynasty.entity.variant.KitsuneVariant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KitsuneEntity
extends Monster {
    public final KitsuneDispatcher dispatcher;
    public final MoveAnalysis moveAnalysis;
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(KitsuneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public KitsuneEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.dispatcher = new KitsuneDispatcher(this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    public static AttributeSupplier setAttributes() {
        return Monster.createMobAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ATTACK_SPEED, (double)0.3f).add(Attributes.FOLLOW_RANGE, 25.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).build();
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, new AnimatedMeleeAttackGoal<KitsuneEntity>(this, 1.2, false, (entity, target) -> entity.dispatcher.attack()));
        this.goalSelector.addGoal(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.2, 25.0f));
        this.goalSelector.addGoal(4, new SpawnMobNearPlayerGoal<KitsuneEntity>(this, 10, 3));
        this.goalSelector.addGoal(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public void tick() {
        super.tick();
        this.moveAnalysis.update();
        if (this.level().isClientSide) {
            boolean isMovingOnGround;
            boolean bl = isMovingOnGround = this.moveAnalysis.isMovingHorizontally() && this.onGround();
            Runnable animationRunner = isMovingOnGround ? this.dispatcher::walk : this.dispatcher::idle;
            animationRunner.run();
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_TYPE_VARIANT, (Object)0);
    }

    public KitsuneVariant getVariant() {
        return KitsuneVariant.byId(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(KitsuneVariant variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        KitsuneVariant variant = (KitsuneVariant)((Object)Util.getRandom((Object[])KitsuneVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)pCompound.getInt("Variant"));
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Variant", this.getTypeVariant());
    }

    public int getCurrentSwingDuration() {
        return 18;
    }

    static boolean hurtAndThrowTarget(LivingEntity pKitsune, LivingEntity pTarget) {
        Level level;
        float f1 = (float)pKitsune.getAttributeValue(Attributes.ATTACK_DAMAGE);
        float f = (int)f1 > 0 ? f1 / 2.0f + (float)pKitsune.level().random.nextInt((int)f1) : f1;
        DamageSource damagesource = pKitsune.damageSources().mobAttack(pKitsune);
        boolean flag = pTarget.hurt(pTarget.damageSources().mobAttack(pKitsune), f);
        if (flag && (level = pKitsune.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)pTarget, (DamageSource)damagesource);
            HoglinBase.throwTarget((LivingEntity)pKitsune, (LivingEntity)pTarget);
        }
        return flag;
    }

    public boolean doHurtTarget(@NotNull Entity pEntity) {
        if (!(pEntity instanceof LivingEntity)) {
            return false;
        }
        this.playSound(SoundEvents.FOX_BITE, 1.0f, 0.4f);
        return KitsuneEntity.hurtAndThrowTarget((LivingEntity)this, (LivingEntity)pEntity);
    }

    public int getMaxSpawnClusterSize() {
        return 6;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.FOX_AMBIENT;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        return SoundEvents.FOX_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.FOX_DEATH;
    }

    protected float getSoundVolume() {
        return 0.5f;
    }

    public float getVoicePitch() {
        return 0.5f;
    }
}

