/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.entity.custom;

import javax.annotation.Nullable;
import mod.azure.azurelib.common.util.MoveAnalysis;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.veroxuniverse.samurai_dynasty.client.entities.OnibiDispatcher;
import org.jetbrains.annotations.NotNull;

public class OnibiEntity
extends Monster {
    public final OnibiDispatcher dispatcher;
    public final MoveAnalysis moveAnalysis;
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;
    private float nextFlap = 1.0f;

    public OnibiEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.xpReward = 10;
        this.dispatcher = new OnibiDispatcher(this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    public static AttributeSupplier setAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FLYING_SPEED, (double)0.4f).add(Attributes.MOVEMENT_SPEED, (double)0.2f).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 48.0).build();
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level pLevel) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, pLevel);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed += (float)(!this.onGround() && !this.isPassenger() ? 4 : -1) * 0.3f;
        this.flapSpeed = Mth.clamp((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.onGround() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 vec3 = this.getDeltaMovement();
        if (!this.onGround() && vec3.y < 0.0) {
            this.setDeltaMovement(vec3.multiply(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(2, (Goal)new SpiritFloatGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.3, true));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, false));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, false));
    }

    public void tick() {
        super.tick();
        this.moveAnalysis.update();
        if (this.level().isClientSide) {
            boolean isMoving = this.moveAnalysis.isMoving();
            Runnable animationRunner = isMoving ? this.dispatcher::walk : this.dispatcher::idle;
            animationRunner.run();
        }
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, @NotNull DamageSource pSource) {
        return false;
    }

    protected void checkFallDamage(double pY, boolean pOnGround, @NotNull BlockState pState, @NotNull BlockPos pPos) {
    }

    public boolean isSensitiveToWater() {
        return true;
    }

    public boolean doHurtTarget(@NotNull Entity pEntity) {
        if (!super.doHurtTarget(pEntity)) {
            return false;
        }
        if (pEntity instanceof LivingEntity) {
            pEntity.igniteForSeconds(20.0f);
        }
        return true;
    }

    protected SoundEvent getAmbientSound() {
        return SoundEvents.ALLAY_AMBIENT_WITHOUT_ITEM;
    }

    protected SoundEvent getHurtSound(@NotNull DamageSource damageSourceIn) {
        return SoundEvents.ALLAY_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ALLAY_DEATH;
    }

    protected float getSoundVolume() {
        return 0.2f;
    }

    protected boolean isFlapping() {
        return this.flyDist > this.nextFlap;
    }

    public boolean isPushable() {
        return true;
    }

    protected void doPush(@NotNull Entity pEntity) {
        if (!(pEntity instanceof Player)) {
            super.doPush(pEntity);
        }
    }

    public void aiStep() {
        if (this.level().isClientSide) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getRandomX(0.25), this.getRandomY(), this.getRandomZ(0.25), 0.0, 0.0, 0.0);
            }
        }
        super.aiStep();
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    @NotNull
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.4f));
    }

    protected void onFlap() {
        this.nextFlap = this.flyDist + this.flapSpeed / 2.0f;
    }

    static class SpiritFloatGoal
    extends WaterAvoidingRandomFlyingGoal {
        public SpiritFloatGoal(PathfinderMob pMob, double pSpeed) {
            super(pMob, pSpeed);
        }

        @Nullable
        protected Vec3 getPosition() {
            Vec3 vec3 = null;
            if (this.mob.isInWater()) {
                vec3 = LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)15);
            }
            if (this.mob.getRandom().nextFloat() >= this.probability) {
                vec3 = this.getTreePos();
            }
            if (this.mob.getTarget() != null) {
                vec3 = this.mob.getTarget().getPosition(20.0f);
            }
            return vec3 == null ? super.getPosition() : vec3;
        }

        @Nullable
        private Vec3 getTreePos() {
            BlockPos blockpos = this.mob.blockPosition();
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = new BlockPos.MutableBlockPos();
            for (BlockPos blockpos1 : BlockPos.betweenClosed((int)Mth.floor((double)(this.mob.getX() - 3.0)), (int)Mth.floor((double)(this.mob.getY() - 6.0)), (int)Mth.floor((double)(this.mob.getZ() - 3.0)), (int)Mth.floor((double)(this.mob.getX() + 3.0)), (int)Mth.floor((double)(this.mob.getY() + 6.0)), (int)Mth.floor((double)(this.mob.getZ() + 3.0)))) {
                BlockState blockstate;
                boolean flag;
                if (blockpos.equals((Object)blockpos1) || !(flag = (blockstate = this.mob.level().getBlockState((BlockPos)blockpos$mutableblockpos1.setWithOffset((Vec3i)blockpos1, Direction.DOWN))).getBlock() instanceof LeavesBlock || blockstate.is(BlockTags.LOGS)) || !this.mob.level().isEmptyBlock(blockpos1) || !this.mob.level().isEmptyBlock((BlockPos)blockpos$mutableblockpos.setWithOffset((Vec3i)blockpos1, Direction.UP))) continue;
                return Vec3.atBottomCenterOf((Vec3i)blockpos1);
            }
            return null;
        }
    }
}

