/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.entity.custom;

import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import mod.azure.azurelib.common.util.MoveAnalysis;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.veroxuniverse.samurai_dynasty.client.projectiles.ThrownShurikenDispatcher;
import net.veroxuniverse.samurai_dynasty.entity.ModEntityTypes;
import net.veroxuniverse.samurai_dynasty.registry.ItemsRegistry;
import org.jetbrains.annotations.NotNull;

public class ThrownShurikenEntity
extends AbstractArrow {
    public final ThrownShurikenDispatcher dispatcher;
    public final MoveAnalysis moveAnalysis;
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.defineId(ThrownShurikenEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @NotNull
    private ItemStack shurikenItem = new ItemStack((ItemLike)ItemsRegistry.SHURIKEN.get());
    private boolean dealtDamage;
    private float playerYaw;
    private float playerPitch;
    private float SHURIKEN_DAMAGE = 6.0f;

    public ThrownShurikenEntity(EntityType<? extends ThrownShurikenEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.dispatcher = new ThrownShurikenDispatcher(this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    public ThrownShurikenEntity(Level pLevel, LivingEntity pShooter, ItemStack pStack) {
        super((EntityType)ModEntityTypes.SHURIKEN.get(), pShooter, pLevel, pStack, null);
        this.shurikenItem = pStack.copy();
        this.entityData.set(ID_FOIL, (Object)pStack.hasFoil());
        this.setOwner((Entity)pShooter);
        this.dispatcher = new ThrownShurikenDispatcher(this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    public ThrownShurikenEntity(Level level, double x, double y, double z, ItemStack itemStack) {
        super((EntityType)ModEntityTypes.SHURIKEN.get(), x, y, z, level, itemStack, itemStack);
        this.dispatcher = new ThrownShurikenDispatcher(this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ID_FOIL, (Object)false);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
        }
        super.tick();
        double dx = this.getDeltaMovement().x();
        double dy = this.getDeltaMovement().y();
        double dz = this.getDeltaMovement().z();
        float horizontalDistance = Mth.sqrt((float)((float)(dx * dx + dz * dz)));
        this.setYRot((float)(Mth.atan2((double)dx, (double)dz) * 57.29577951308232));
        this.setXRot((float)(Mth.atan2((double)dy, (double)horizontalDistance) * 57.29577951308232));
        this.moveAnalysis.update();
        if (this.level().isClientSide) {
            Runnable animationRunner = this.dispatcher::idle;
            animationRunner.run();
        }
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)((Item)ItemsRegistry.SHURIKEN.get()).asItem());
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)((Item)ItemsRegistry.SHURIKEN.get()).asItem());
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : super.findHitEntity(pStartVec, pEndVec);
    }

    protected void onHitEntity(@NotNull EntityHitResult pResult) {
        super.onHitEntity(pResult);
        Entity entity = pResult.getEntity();
        entity.hurt(entity.damageSources().thrown((Entity)this, this.getOwner()), this.SHURIKEN_DAMAGE);
    }

    protected boolean tryPickup(Player pPlayer) {
        return super.tryPickup(pPlayer) || this.isNoPhysics() && this.ownedBy((Entity)pPlayer) && pPlayer.getInventory().add(this.getPickupItem());
    }

    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    public void playerTouch(Player pEntity) {
        if (this.ownedBy((Entity)pEntity) || this.getOwner() == null) {
            super.playerTouch(pEntity);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (pCompound.contains("Shuriken", 10)) {
            this.shurikenItem = ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pCompound.getCompound("Shuriken")).result().orElse(ItemStack.EMPTY);
        }
        this.dealtDamage = pCompound.getBoolean("DealtDamage");
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        CompoundTag shurikenTag = new CompoundTag();
        this.shurikenItem.save((HolderLookup.Provider)shurikenTag);
        pCompound.put("Shuriken", (Tag)shurikenTag);
        pCompound.putBoolean("DealtDamage", this.dealtDamage);
    }

    public void tickDespawn() {
        if (this.pickup != AbstractArrow.Pickup.ALLOWED) {
            super.tickDespawn();
        }
    }

    public void shootFromRotation(Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        super.shootFromRotation(pShooter, pX, pY, pZ, pVelocity, pInaccuracy);
        this.playerYaw = pShooter.getYHeadRot();
        this.playerPitch = pShooter.getXRot();
    }

    public boolean shouldRender(double pX, double pY, double pZ) {
        return true;
    }
}

