/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.entity.goals;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HealPlayerGoal
extends Goal {
    private final Mob mob;
    private final double healRadius;
    private final int healAmount;
    private final int healCooldown;
    private int cooldownCounter;
    private int particleDuration;
    private static final int PARTICLE_LIFETIME = 100;
    private Player targetPlayer;

    public HealPlayerGoal(Mob mob, double healRadius, int healAmount, int healCooldown) {
        this.mob = mob;
        this.healRadius = healRadius;
        this.healAmount = healAmount;
        this.healCooldown = healCooldown;
        this.cooldownCounter = 0;
        this.particleDuration = 0;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return true;
    }

    public boolean canContinueToUse() {
        return this.particleDuration > 0;
    }

    public void tick() {
        Level level = this.mob.level();
        if (level.isClientSide) {
            return;
        }
        for (Player player : level.players()) {
            if (!((double)player.distanceTo((Entity)this.mob) <= this.healRadius) || !player.isAlive() || this.cooldownCounter > 0 || !(player.getHealth() < player.getMaxHealth())) continue;
            player.heal((float)this.healAmount);
            this.targetPlayer = player;
            this.particleDuration = 100;
            this.cooldownCounter = this.healCooldown;
            break;
        }
        if (this.particleDuration > 0 && this.targetPlayer != null) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = (Math.random() - 0.5) * 0.5;
                double offsetZ = (Math.random() - 0.5) * 0.5;
                level.addParticle((ParticleOptions)ParticleTypes.HEART, this.targetPlayer.getX() + offsetX, this.targetPlayer.getY() + 0.5, this.targetPlayer.getZ() + offsetZ, 0.0, 0.0, 0.0);
            }
            --this.particleDuration;
        }
        if (this.cooldownCounter > 0) {
            --this.cooldownCounter;
        }
    }
}

