/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.entity.goals;

import java.util.EnumSet;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class NightVisionGoal
extends Goal {
    private final Mob mob;
    private final double effectRadius;
    private final int effectDuration;
    private final int effectAmplifier;

    public NightVisionGoal(Mob mob, double effectRadius, int effectDuration, int effectAmplifier) {
        this.mob = mob;
        this.effectRadius = effectRadius;
        this.effectDuration = effectDuration;
        this.effectAmplifier = effectAmplifier;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return true;
    }

    public void tick() {
        Level level = this.mob.level();
        if (level.isClientSide) {
            return;
        }
        for (Player player : level.players()) {
            if (!((double)player.distanceTo((Entity)this.mob) <= this.effectRadius) || !player.isAlive()) continue;
            MobEffectInstance nightVision = new MobEffectInstance(MobEffects.NIGHT_VISION, this.effectDuration, this.effectAmplifier, true, false);
            player.addEffect(nightVision);
        }
    }
}

