/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.entity.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.veroxuniverse.samurai_dynasty.entity.ModEntityTypes;
import net.veroxuniverse.samurai_dynasty.entity.custom.OnibiEntity;

public class SpawnMobNearPlayerGoal<T extends Mob>
extends Goal {
    private final T mob;
    private final int spawnRange;
    private final int spawnCount;
    private int delay;

    public SpawnMobNearPlayerGoal(T mob, int spawnRange, int spawnCount) {
        this.mob = mob;
        this.spawnRange = spawnRange;
        this.spawnCount = spawnCount;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        List nearbyPlayers = this.mob.level().getEntitiesOfClass(LivingEntity.class, this.mob.getBoundingBox().inflate((double)this.spawnRange), entity -> entity instanceof Player);
        return !nearbyPlayers.isEmpty() && this.allOnibisAreDead();
    }

    private boolean allOnibisAreDead() {
        List entityList = this.mob.level().getEntitiesOfClass(OnibiEntity.class, this.mob.getBoundingBox().inflate((double)this.spawnRange), onibi -> onibi.isAlive());
        return entityList.isEmpty();
    }

    public void start() {
        this.delay = 60;
    }

    public void tick() {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        for (int i = 0; i < this.spawnCount; ++i) {
            this.spawnOnibi();
        }
        this.delay = 20;
    }

    private void spawnOnibi() {
        BlockPos mobPos;
        BlockPos spawnPos;
        Level level = this.mob.level();
        if (level.isEmptyBlock(spawnPos = (mobPos = this.mob.blockPosition()).offset(this.mob.getRandom().nextInt(3) - 1, 0, this.mob.getRandom().nextInt(3) - 1)) && spawnPos.getY() < level.getMaxBuildHeight()) {
            OnibiEntity onibiEntity = new OnibiEntity((EntityType<? extends Monster>)((EntityType)ModEntityTypes.ONIBI.get()), level);
            onibiEntity.moveTo(spawnPos.getX(), spawnPos.getY(), spawnPos.getZ(), this.mob.getYRot(), 0.0f);
            onibiEntity.setTarget(this.mob.getTarget());
            level.addFreshEntity((Entity)onibiEntity);
        }
    }
}

