/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.veroxuniverse.samurai_dynasty.entity.custom.KunaiEntity;
import net.veroxuniverse.samurai_dynasty.item.ESWeaponItem;
import org.jetbrains.annotations.NotNull;

public class KunaiItem
extends ESWeaponItem
implements ProjectileItem {
    public static final float BASE_DAMAGE = 8.0f;

    public KunaiItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public int getUseDuration(ItemStack pStack) {
        return 300;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        pPlayer.getCooldowns().addCooldown((Item)this, 20);
        pLevel.playSound((Player)null, pPlayer.getX(), pPlayer.getY(), pPlayer.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (pLevel.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!pLevel.isClientSide) {
            KunaiEntity kunaiEntity = new KunaiEntity(pLevel, (LivingEntity)pPlayer);
            kunaiEntity.setItem(itemstack);
            kunaiEntity.shootFromRotation((Entity)pPlayer, pPlayer.getXRot(), pPlayer.getYRot(), 0.0f, 2.5f, 2.0f);
            pLevel.addFreshEntity((Entity)kunaiEntity);
        }
        pPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        if (!pPlayer.getAbilities().instabuild) {
            itemstack.hurtAndBreak(5, (LivingEntity)pPlayer, EquipmentSlot.MAINHAND);
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)pLevel.isClientSide());
    }

    public void appendHoverText(@NotNull ItemStack stack, Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        components.add((Component)Component.literal((String)"Throwable Item:").withStyle(ChatFormatting.GRAY));
        components.add((Component)Component.literal((String)" 6 Ranged Damage").withStyle(ChatFormatting.DARK_GREEN));
        super.appendHoverText(stack, context, components, flag);
    }

    public boolean hurtEnemy(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.hurtAndBreak(2, pAttacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public boolean mineBlock(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if ((double)pState.getDestroySpeed((BlockGetter)pLevel, pPos) != 0.0) {
            pStack.hurtAndBreak(2, pEntityLiving, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        KunaiEntity kunaiEntity = new KunaiEntity(level, position.x(), position.y(), position.z(), itemStack.copyWithCount(1));
        return kunaiEntity;
    }
}

