/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.EventHooks;

public class YumiBow
extends BowItem {
    public YumiBow(Item.Properties pProperties) {
        super(pProperties);
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        Player player;
        ItemStack itemstack;
        if (pEntityLiving instanceof Player && !(itemstack = (player = (Player)pEntityLiving).getProjectile(pStack)).isEmpty()) {
            int i = this.getUseDuration(pStack, pEntityLiving) - pTimeLeft;
            if ((i = EventHooks.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)i, (!itemstack.isEmpty() ? 1 : 0) != 0)) < 0) {
                return;
            }
            float f = YumiBow.getPowerForTime(i);
            if (!((double)f < 0.1)) {
                List list = YumiBow.draw((ItemStack)pStack, (ItemStack)itemstack, (LivingEntity)player);
                if (pLevel instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)pLevel;
                    if (!list.isEmpty()) {
                        float velocityMultiplier = 4.0f;
                        this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), pStack, list, f * velocityMultiplier, 1.0f, f == 1.0f, null);
                    }
                }
                pLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }

    protected void shootProjectile(LivingEntity p_331372_, Projectile p_332000_, int p_330631_, float p_331251_, float p_331199_, float p_330857_, @Nullable LivingEntity p_331572_) {
        p_332000_.shootFromRotation((Entity)p_331372_, p_331372_.getXRot(), p_331372_.getYRot() + p_330857_, 0.0f, p_331251_, p_331199_);
    }

    public static float getPowerForTime(int pCharge) {
        float f = (float)pCharge / 16.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity pLivingEntity) {
        return 72000;
    }

    public int getDefaultProjectileRange() {
        return 25;
    }
}

