/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.item.armor;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.veroxuniverse.samurai_dynasty.item.armor.lib.SamuraiArmorItem;
import net.veroxuniverse.samurai_dynasty.registry.ArmorMaterialsRegistry;

public class SteelSamuraiArmorItem
extends SamuraiArmorItem {
    private ItemStack itemStack = new ItemStack((ItemLike)this);

    public SteelSamuraiArmorItem(Holder<ArmorMaterial> holder, ArmorItem.Type type, Item.Properties properties) {
        super(holder, type, properties);
    }

    public String getColorNameFromRGB(int rgbValue) {
        for (DyeColor color : DyeColor.values()) {
            if (color.getTextureDiffuseColor() != rgbValue) continue;
            return color.getName().toLowerCase();
        }
        return DyeColor.RED.getName().toLowerCase();
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return this.material == ArmorMaterialsRegistry.SAMURAI_STEEL;
    }

    public static int getColor(ItemStack stack) {
        DyeColor color = (DyeColor)stack.get(DataComponents.BASE_COLOR);
        return color != null ? color.getTextureDiffuseColor() : DyeColor.RED.getTextureDiffuseColor();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }
}

