/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.registry;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.veroxuniverse.samurai_dynasty.block.CloudBlock;
import net.veroxuniverse.samurai_dynasty.block.DragonBlock;
import net.veroxuniverse.samurai_dynasty.block.LampBlock;
import net.veroxuniverse.samurai_dynasty.block.ModFlammableRotatedPillarBlock;
import net.veroxuniverse.samurai_dynasty.block.ModHorzontalBlock;
import net.veroxuniverse.samurai_dynasty.block.RoofBlock;
import net.veroxuniverse.samurai_dynasty.block.SpiritBlossomLeavesBlock;
import net.veroxuniverse.samurai_dynasty.block.SpiritWoodLeavesBlock;
import net.veroxuniverse.samurai_dynasty.block.StatueBlock;
import net.veroxuniverse.samurai_dynasty.registry.ItemsRegistry;
import net.veroxuniverse.samurai_dynasty.worldgen.ModTreeGrowers;

public class BlocksRegistry {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"samurai_dynasty");
    public static final DeferredBlock<Block> JADE_ORE = BlocksRegistry.registerBlock("jade_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_ORE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> DEEPSLATE_JADE_ORE = BlocksRegistry.registerBlock("deepslate_jade_ore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)3, (int)7), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_DIAMOND_ORE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> JADE_BLOCK = BlocksRegistry.registerBlock("jade_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> STEEL_BLOCK = BlocksRegistry.registerBlock("steel_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_STONE_BASE = BlocksRegistry.registerBlock("spirit_stone_base", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_STONE = BlocksRegistry.registerBlock("spirit_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_STONE_STAIRS = BlocksRegistry.registerBlock("spirit_stone_stairs", () -> new StairBlock(((Block)SPIRIT_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_STONE_SLAB = BlocksRegistry.registerBlock("spirit_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_STONE_WALL = BlocksRegistry.registerBlock("spirit_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE_WALL)));
    public static final DeferredBlock<Block> MOSSY_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("mossy_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> MOSSY_SPIRIT_STONE_BRICK_STAIRS = BlocksRegistry.registerBlock("mossy_spirit_stone_brick_stairs", () -> new StairBlock(((Block)MOSSY_SPIRIT_STONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> MOSSY_SPIRIT_STONE_BRICK_SLAB = BlocksRegistry.registerBlock("mossy_spirit_stone_brick_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> MOSSY_SPIRIT_STONE_BRICK_WALL = BlocksRegistry.registerBlock("mossy_spirit_stone_brick_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE_WALL)));
    public static final DeferredBlock<Block> DRAGON_SPIRIT_STONE = BlocksRegistry.registerBlock("dragon_spirit_stone", () -> new DragonBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> POLISHED_SPIRIT_STONE = BlocksRegistry.registerBlock("polished_spirit_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> POLISHED_SPIRIT_STONE_STAIRS = BlocksRegistry.registerBlock("polished_spirit_stone_stairs", () -> new StairBlock(((Block)POLISHED_SPIRIT_STONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> POLISHED_SPIRIT_STONE_SLAB = BlocksRegistry.registerBlock("polished_spirit_stone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> POLISHED_SPIRIT_STONE_WALL = BlocksRegistry.registerBlock("polished_spirit_stone_wall", () -> new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE_WALL)));
    public static final DeferredBlock<Block> CHISELED_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("chiseled_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CHISELED_PATTERN_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("chiseled_pattern_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> MOSAIC_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("mosaic_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> PATTERN_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("pattern_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> PATTERN_MOSSY_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("pattern_mossy_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> PATH_SPIRIT_STONE_BRICKS = BlocksRegistry.registerBlock("path_spirit_stone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> TANUKI_STATUE = BlocksRegistry.registerBlock("tanuki_statue", () -> new StatueBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> KOMAINU_STATUE = BlocksRegistry.registerBlock("komainu_statue", () -> new StatueBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> KAWAUSO_STATUE = BlocksRegistry.registerBlock("kawauso_statue", () -> new StatueBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> STONE_ROOF = BlocksRegistry.registerBlock("stone_roof", () -> new RoofBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> STONE_ROOF_CORNER = BlocksRegistry.registerBlock("stone_roof_corner", () -> new RoofBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> STONE_ROOF_TOP = BlocksRegistry.registerBlock("stone_roof_top", () -> new RoofBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_LAMP = BlocksRegistry.registerBlock("spirit_lamp", () -> new LampBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).lightLevel(p_152607_ -> 14)));
    public static final DeferredBlock<Block> STONE_LAMP = BlocksRegistry.registerBlock("stone_lamp", () -> new LampBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).lightLevel(p_152607_ -> 14)));
    public static final DeferredBlock<Block> ANDESITE_LAMP = BlocksRegistry.registerBlock("andesite_lamp", () -> new LampBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).lightLevel(p_152607_ -> 14)));
    public static final DeferredBlock<Block> DIORITE_LAMP = BlocksRegistry.registerBlock("diorite_lamp", () -> new LampBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).lightLevel(p_152607_ -> 14)));
    public static final DeferredBlock<Block> GRANITE_LAMP = BlocksRegistry.registerBlock("granite_lamp", () -> new LampBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).lightLevel(p_152607_ -> 14)));
    public static final DeferredBlock<Block> DEEPSLATE_LAMP = BlocksRegistry.registerBlock("deepslate_lamp", () -> new LampBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).lightLevel(p_152607_ -> 14)));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_LOG = BlocksRegistry.registerBlock("spirit_blossom_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<Block> STRIPPED_SPIRIT_BLOSSOM_LOG = BlocksRegistry.registerBlock("stripped_spirit_blossom_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_WOOD = BlocksRegistry.registerBlock("spirit_blossom_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<Block> STRIPPED_SPIRIT_BLOSSOM_WOOD = BlocksRegistry.registerBlock("stripped_spirit_blossom_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_PLANKS = BlocksRegistry.registerBlock("spirit_blossom_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_STAIRS = BlocksRegistry.registerBlock("spirit_blossom_stairs", () -> new StairBlock(((Block)SPIRIT_BLOSSOM_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_SLAB = BlocksRegistry.registerBlock("spirit_blossom_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_FENCE = BlocksRegistry.registerBlock("spirit_blossom_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_FENCE_GATE = BlocksRegistry.registerBlock("spirit_blossom_fence_gate", () -> new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_BUTTON = BlocksRegistry.registerBlock("spirit_blossom_button", () -> new ButtonBlock(BlockSetType.OAK, 10, BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().noCollission()));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_PRESSURE_PLATE = BlocksRegistry.registerBlock("spirit_blossom_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_DOOR = BlocksRegistry.registerBlock("spirit_blossom_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_TRAPDOOR = BlocksRegistry.registerBlock("spirit_blossom_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_LEAVES = BlocksRegistry.registerBlock("spirit_blossom_leaves", () -> new SpiritBlossomLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_SAPLING = BlocksRegistry.registerBlock("spirit_blossom_sapling", () -> new SaplingBlock(ModTreeGrowers.SPIRIT_BLOSSOM_TREE_GROWER, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_ROOTS = BlocksRegistry.registerBlock("spirit_blossom_roots", () -> new ModHorzontalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.VINE).noOcclusion().noCollission()));
    public static final DeferredBlock<Block> SPIRIT_BLOSSOM_BRANCH = BlocksRegistry.registerBlock("spirit_blossom_branch", () -> new ModHorzontalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.VINE).noOcclusion().noCollission()));
    public static final DeferredBlock<Block> SPIRIT_MOSS_BLOCK = BlocksRegistry.registerBlock("spirit_moss_block", () -> new MossBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSS_BLOCK).strength(0.2f)));
    public static final DeferredBlock<Block> SPIDER_LILLY = BlocksRegistry.registerBlock("spider_lilly", () -> new FlowerBlock(MobEffects.POISON, 2.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ALLIUM)));
    public static final DeferredBlock<Block> POTTED_SPIDER_LILLY = BlocksRegistry.registerBlockWithoutItem("potted_spider_lilly", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, SPIDER_LILLY, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ALLIUM)));
    public static final DeferredBlock<Block> SPIRIT_PETALS = BlocksRegistry.registerBlock("spirit_petals", () -> new CarpetBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MOSS_CARPET).strength(4.0f).noOcclusion().instabreak()));
    public static final DeferredBlock<Block> SPIRIT_WOOD_LOG = BlocksRegistry.registerBlock("spirit_wood_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<Block> STRIPPED_SPIRIT_WOOD_LOG = BlocksRegistry.registerBlock("stripped_spirit_wood_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<Block> SPIRIT_WOOD = BlocksRegistry.registerBlock("spirit_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final DeferredBlock<Block> STRIPPED_SPIRIT_WOOD = BlocksRegistry.registerBlock("stripped_spirit_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    public static final DeferredBlock<Block> SPIRIT_WOOD_PLANKS = BlocksRegistry.registerBlock("spirit_wood_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<Block> SPIRIT_WOOD_STAIRS = BlocksRegistry.registerBlock("spirit_wood_stairs", () -> new StairBlock(((Block)SPIRIT_WOOD_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_WOOD_SLAB = BlocksRegistry.registerBlock("spirit_wood_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_WOOD_FENCE = BlocksRegistry.registerBlock("spirit_wood_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_WOOD_FENCE_GATE = BlocksRegistry.registerBlock("spirit_wood_fence_gate", () -> new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_WOOD_BUTTON = BlocksRegistry.registerBlock("spirit_wood_button", () -> new ButtonBlock(BlockSetType.OAK, 10, BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().noCollission()));
    public static final DeferredBlock<Block> SPIRIT_WOOD_PRESSURE_PLATE = BlocksRegistry.registerBlock("spirit_wood_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_WOOD_DOOR = BlocksRegistry.registerBlock("spirit_wood_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_WOOD_TRAPDOOR = BlocksRegistry.registerBlock("spirit_wood_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SPIRIT_WOOD_LEAVES = BlocksRegistry.registerBlock("spirit_wood_leaves", () -> new SpiritWoodLeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final DeferredBlock<Block> SPIRIT_WOOD_SAPLING = BlocksRegistry.registerBlock("spirit_wood_sapling", () -> new SaplingBlock(ModTreeGrowers.SPIRIT_WOOD_TREE_GROWER, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING)));
    public static final DeferredBlock<Block> SPIRIT_WOOD_ROOTS = BlocksRegistry.registerBlock("spirit_wood_roots", () -> new ModHorzontalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.VINE).noOcclusion().noCollission()));
    public static final DeferredBlock<Block> SPIRIT_WOOD_BRANCH = BlocksRegistry.registerBlock("spirit_wood_branch", () -> new ModHorzontalBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.VINE).noOcclusion().noCollission()));
    public static final DeferredBlock<Block> CLOUD = BlocksRegistry.registerBlockWithoutItem("cloud", () -> new CloudBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHITE_WOOL).dynamicShape().mapColor(MapColor.WOOL).noOcclusion()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlocksRegistry.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerBlockWithoutItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static ToIntFunction<BlockState> litBlockEmission(int pLightValue) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? pLightValue : 0;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ItemsRegistry.ITEMS_BUILDING.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

