/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.worldgen;

import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.veroxuniverse.samurai_dynasty.registry.BlocksRegistry;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIDER_LILLY_KEY = ModConfiguredFeatures.registerKey("spider_lilly");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIRIT_PETALS_KEY = ModConfiguredFeatures.registerKey("spirit_petals");
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOSS_KEY = ModConfiguredFeatures.registerKey("moss");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        ModConfiguredFeatures.register(context, SPIDER_LILLY_KEY, Feature.FLOWER, new RandomPatchConfiguration(42, 6, 2, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIDER_LILLY.get()))))));
        ModConfiguredFeatures.register(context, SPIRIT_PETALS_KEY, Feature.FLOWER, new RandomPatchConfiguration(42, 6, 1, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_PETALS.get()))))));
        ModConfiguredFeatures.register(context, MOSS_KEY, Feature.FLOWER, new RandomPatchConfiguration(42, 6, 1, PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.MOSS_CARPET)))));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"samurai_dynasty", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

