/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.worldgen;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.veroxuniverse.samurai_dynasty.utils.ModTags;
import net.veroxuniverse.samurai_dynasty.worldgen.ModConfiguredFeatures;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> SPIDER_LILLY_PLACED_KEY = ModPlacedFeatures.registerKey("spider_lilly_placed");
    public static final ResourceKey<PlacedFeature> SPIRIT_PETALS_PLACED_KEY = ModPlacedFeatures.registerKey("spirit_petals_placed");
    public static final ResourceKey<PlacedFeature> MOSS_PLACED_KEY = ModPlacedFeatures.registerKey("moss_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, SPIDER_LILLY_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.SPIDER_LILLY_KEY), List.of(RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(0, -1, 0), ModTags.SPIRIT_VALID_GROUND)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, SPIRIT_PETALS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.SPIRIT_PETALS_KEY), List.of(RarityFilter.onAverageOnceEvery((int)5), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(0, -1, 0), ModTags.SPIRIT_VALID_GROUND)), BiomeFilter.biome()));
        ModPlacedFeatures.register(context, MOSS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.MOSS_KEY), List.of(RarityFilter.onAverageOnceEvery((int)7), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesTag((Vec3i)new BlockPos(0, -1, 0), ModTags.SPIRIT_VALID_GROUND)), BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"samurai_dynasty", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

