/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.worldgen.features;

import com.google.common.collect.ImmutableList;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.TYGFeatures;
import dev.corgitaco.ohthetreesyoullgrow.world.level.levelgen.feature.configurations.TreeFromStructureNBTConfig;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.WeightedPlacedFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AlterGroundDecorator;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.veroxuniverse.samurai_dynasty.registry.BlocksRegistry;

public class ModTreeConfiguredFeatures {
    public static final Map<ResourceKey<ConfiguredFeature<?, ?>>, ConfiguredFeatureFactory> CONFIGURED_FEATURES_MOD = new Reference2ObjectOpenHashMap();
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIRIT_WOOD_TREE1 = ModTreeConfiguredFeatures.createConfiguredFeature("spirit_wood_tree1", TYGFeatures.TREE_FROM_NBT_V1, (BootstrapContext<ConfiguredFeature<?, ?>> ctx) -> new TreeFromStructureNBTConfig.Builder().baseLocation(ModTreeConfiguredFeatures.createLocation("features/trees/spirit_wood_tree/spirit_wood_tree_trunk1")).canopyLocation(ModTreeConfiguredFeatures.createLocation("features/trees/spirit_wood_tree/spirit_wood_tree_canopy1")).height((IntProvider)UniformInt.of((int)5, (int)6)).logProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_WOOD.get()))).leavesProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_WOOD_LEAVES.get()))).logTarget(Set.of((Block)BlocksRegistry.SPIRIT_WOOD.get())).leavesTarget(Set.of((Block)BlocksRegistry.SPIRIT_WOOD_LEAVES.get())).growableOn(BlockPredicate.matchesTag((TagKey)BlockTags.DIRT)).leavesPlacementFilter(BlockPredicate.replaceable()).maxLogDepth(3).treeDecorators((List)ImmutableList.of((Object)ModTreeConfiguredFeatures.spiritMossBlockDecorator())).placeFromNBT(Set.of((Block)BlocksRegistry.SPIRIT_WOOD_BRANCH.get(), (Block)BlocksRegistry.SPIRIT_WOOD_ROOTS.get())).isSapling(false).orientation(TreeFromStructureNBTConfig.Orientation.STANDARD).build());
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIRIT_WOOD_TREE2 = ModTreeConfiguredFeatures.createConfiguredFeature("spirit_wood_tree2", TYGFeatures.TREE_FROM_NBT_V1, (BootstrapContext<ConfiguredFeature<?, ?>> ctx) -> new TreeFromStructureNBTConfig.Builder().baseLocation(ModTreeConfiguredFeatures.createLocation("features/trees/spirit_wood_tree/spirit_wood_tree_trunk2")).canopyLocation(ModTreeConfiguredFeatures.createLocation("features/trees/spirit_wood_tree/spirit_wood_tree_canopy2")).height((IntProvider)UniformInt.of((int)5, (int)6)).logProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_WOOD.get()))).leavesProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_WOOD_LEAVES.get()))).logTarget(Set.of((Block)BlocksRegistry.SPIRIT_WOOD.get())).leavesTarget(Set.of((Block)BlocksRegistry.SPIRIT_WOOD_LEAVES.get())).growableOn(BlockPredicate.matchesTag((TagKey)BlockTags.DIRT)).leavesPlacementFilter(BlockPredicate.replaceable()).maxLogDepth(3).treeDecorators((List)ImmutableList.of((Object)ModTreeConfiguredFeatures.spiritMossBlockDecorator())).isSapling(false).orientation(TreeFromStructureNBTConfig.Orientation.STANDARD).build());
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIRIT_WOOD_TREE3 = ModTreeConfiguredFeatures.createConfiguredFeature("spirit_wood_tree3", TYGFeatures.TREE_FROM_NBT_V1, (BootstrapContext<ConfiguredFeature<?, ?>> ctx) -> new TreeFromStructureNBTConfig.Builder().baseLocation(ModTreeConfiguredFeatures.createLocation("features/trees/spirit_wood_tree/spirit_wood_tree_trunk3")).canopyLocation(ModTreeConfiguredFeatures.createLocation("features/trees/spirit_wood_tree/spirit_wood_tree_canopy3")).height((IntProvider)UniformInt.of((int)5, (int)10)).logProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_WOOD.get()))).leavesProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_WOOD_LEAVES.get()))).logTarget(Set.of((Block)BlocksRegistry.SPIRIT_WOOD.get())).leavesTarget(Set.of((Block)BlocksRegistry.SPIRIT_WOOD_LEAVES.get())).growableOn(BlockPredicate.matchesTag((TagKey)BlockTags.DIRT)).leavesPlacementFilter(BlockPredicate.replaceable()).maxLogDepth(3).treeDecorators((List)ImmutableList.of((Object)ModTreeConfiguredFeatures.spiritMossBlockDecorator())).isSapling(false).orientation(TreeFromStructureNBTConfig.Orientation.STANDARD).build());
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIRIT_WOOD_TREES = ModTreeConfiguredFeatures.createConfiguredFeature("spirit_wood_trees", Feature.RANDOM_SELECTOR, (BootstrapContext<ConfiguredFeature<?, ?>> configuredFeatureBootstrapContext) -> {
        HolderGetter lookup = configuredFeatureBootstrapContext.lookup(Registries.CONFIGURED_FEATURE);
        return new RandomFeatureConfiguration((List)ImmutableList.of((Object)new WeightedPlacedFeature(ModTreeConfiguredFeatures.createPlacedFeatureDirect(lookup.getOrThrow(SPIRIT_WOOD_TREE2), new PlacementModifier[0]), 0.15f), (Object)new WeightedPlacedFeature(ModTreeConfiguredFeatures.createPlacedFeatureDirect(lookup.getOrThrow(SPIRIT_WOOD_TREE3), new PlacementModifier[0]), 0.35f)), ModTreeConfiguredFeatures.createPlacedFeatureDirect(lookup.getOrThrow(SPIRIT_WOOD_TREE1), new PlacementModifier[0]));
    });
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIRIT_BLOSSOM_TREE1 = ModTreeConfiguredFeatures.createConfiguredFeature("spirit_blossom_tree1", TYGFeatures.TREE_FROM_NBT_V1, (BootstrapContext<ConfiguredFeature<?, ?>> ctx) -> new TreeFromStructureNBTConfig.Builder().baseLocation(ModTreeConfiguredFeatures.createLocation("features/trees/spirit_blossom_tree/spirit_blossom_tree_trunk1")).canopyLocation(ModTreeConfiguredFeatures.createLocation("features/trees/spirit_blossom_tree/spirit_blossom_tree_canopy1")).height((IntProvider)UniformInt.of((int)7, (int)8)).logProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_BLOSSOM_WOOD.get()))).leavesProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_BLOSSOM_LEAVES.get()))).logTarget(Set.of((Block)BlocksRegistry.SPIRIT_BLOSSOM_WOOD.get())).leavesTarget(Set.of((Block)BlocksRegistry.SPIRIT_BLOSSOM_LEAVES.get())).growableOn(BlockPredicate.anyOf((BlockPredicate)BlockPredicate.matchesTag((TagKey)BlockTags.DIRT), (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.MOSS_BLOCK}))).leavesPlacementFilter(BlockPredicate.replaceable()).maxLogDepth(3).treeDecorators((List)ImmutableList.of((Object)ModTreeConfiguredFeatures.mossBlockDecorator())).isSapling(false).orientation(TreeFromStructureNBTConfig.Orientation.STANDARD).build());
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIRIT_BLOSSOM_TREE2 = ModTreeConfiguredFeatures.createConfiguredFeature("spirit_blossom_tree2", TYGFeatures.TREE_FROM_NBT_V1, (BootstrapContext<ConfiguredFeature<?, ?>> ctx) -> new TreeFromStructureNBTConfig.Builder().baseLocation(ModTreeConfiguredFeatures.createLocation("features/trees/spirit_blossom_tree/spirit_blossom_tree_trunk2")).canopyLocation(ModTreeConfiguredFeatures.createLocation("features/trees/spirit_blossom_tree/spirit_blossom_tree_canopy2")).height((IntProvider)UniformInt.of((int)5, (int)8)).logProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_BLOSSOM_WOOD.get()))).leavesProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)BlocksRegistry.SPIRIT_BLOSSOM_LEAVES.get()))).logTarget(Set.of((Block)BlocksRegistry.SPIRIT_BLOSSOM_WOOD.get())).leavesTarget(Set.of((Block)BlocksRegistry.SPIRIT_BLOSSOM_LEAVES.get())).growableOn(BlockPredicate.anyOf((BlockPredicate)BlockPredicate.matchesTag((TagKey)BlockTags.DIRT), (BlockPredicate)BlockPredicate.matchesBlocks((Block[])new Block[]{Blocks.MOSS_BLOCK}))).leavesPlacementFilter(BlockPredicate.replaceable()).maxLogDepth(3).treeDecorators((List)ImmutableList.of((Object)ModTreeConfiguredFeatures.mossBlockDecorator())).isSapling(false).orientation(TreeFromStructureNBTConfig.Orientation.STANDARD).build());
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPIRIT_BLOSSOM_TREES = ModTreeConfiguredFeatures.createConfiguredFeature("spirit_blossom_trees", Feature.RANDOM_SELECTOR, (BootstrapContext<ConfiguredFeature<?, ?>> configuredFeatureBootstrapContext) -> {
        HolderGetter lookup = configuredFeatureBootstrapContext.lookup(Registries.CONFIGURED_FEATURE);
        return new RandomFeatureConfiguration((List)ImmutableList.of((Object)new WeightedPlacedFeature(ModTreeConfiguredFeatures.createPlacedFeatureDirect(lookup.getOrThrow(SPIRIT_BLOSSOM_TREE1), new PlacementModifier[0]), 0.35f)), ModTreeConfiguredFeatures.createPlacedFeatureDirect(lookup.getOrThrow(SPIRIT_BLOSSOM_TREE2), new PlacementModifier[0]));
    });

    public static ResourceLocation createLocation(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"samurai_dynasty", (String)path);
    }

    public static AlterGroundDecorator spiritMossBlockDecorator() {
        return new AlterGroundDecorator((BlockStateProvider)SimpleStateProvider.simple((BlockState)((Block)BlocksRegistry.SPIRIT_MOSS_BLOCK.get()).defaultBlockState()));
    }

    public static AlterGroundDecorator mossBlockDecorator() {
        return new AlterGroundDecorator((BlockStateProvider)SimpleStateProvider.simple((BlockState)Blocks.MOSS_BLOCK.defaultBlockState()));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<ConfiguredFeature<?, ?>> createConfiguredFeature(String id, Supplier<? extends F> feature, Function<BootstrapContext<ConfiguredFeature<?, ?>>, ? extends FC> config) {
        ResourceLocation location = ModTreeConfiguredFeatures.createLocation(id);
        ResourceKey configuredFeatureResourceKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)location);
        CONFIGURED_FEATURES_MOD.put(configuredFeatureResourceKey, configuredFeatureHolderGetter -> new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)config.apply(configuredFeatureHolderGetter)));
        return configuredFeatureResourceKey;
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<ConfiguredFeature<?, ?>> createConfiguredFeature(String id, F feature, Function<BootstrapContext<ConfiguredFeature<?, ?>>, ? extends FC> config) {
        ResourceLocation location = ModTreeConfiguredFeatures.createLocation(id);
        ResourceKey configuredFeatureResourceKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)location);
        CONFIGURED_FEATURES_MOD.put(configuredFeatureResourceKey, configuredFeatureHolderGetter -> new ConfiguredFeature(feature, (FeatureConfiguration)config.apply(configuredFeatureHolderGetter)));
        return configuredFeatureResourceKey;
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<ConfiguredFeature<?, ?>> createConfiguredFeature(String id, Supplier<? extends F> feature, Supplier<? extends FC> config) {
        ResourceLocation location = ModTreeConfiguredFeatures.createLocation(id);
        ResourceKey configuredFeatureResourceKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)location);
        CONFIGURED_FEATURES_MOD.put(configuredFeatureResourceKey, configuredFeatureHolderGetter -> new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)config.get()));
        return configuredFeatureResourceKey;
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> ResourceKey<ConfiguredFeature<?, ?>> createConfiguredFeature(String id, F feature, Supplier<? extends FC> config) {
        ResourceLocation location = ModTreeConfiguredFeatures.createLocation(id);
        ResourceKey configuredFeatureResourceKey = ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)location);
        CONFIGURED_FEATURES_MOD.put(configuredFeatureResourceKey, configuredFeatureHolderGetter -> new ConfiguredFeature(feature, (FeatureConfiguration)config.get()));
        return configuredFeatureResourceKey;
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<?, ?>> createConfiguredFeature(F feature, Supplier<? extends FC> config) {
        return Holder.direct((Object)new ConfiguredFeature(feature, (FeatureConfiguration)config.get()));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<?, ?>> createConfiguredFeature(F feature, FC config) {
        return Holder.direct((Object)new ConfiguredFeature(feature, config));
    }

    public static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<?, ?>> createConfiguredFeature(Supplier<F> feature, Supplier<FC> config) {
        return Holder.direct((Object)new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)config.get()));
    }

    public static <FC extends FeatureConfiguration> Holder<PlacedFeature> createPlacedFeatureDirect(Holder<ConfiguredFeature<?, ?>> feature, PlacementModifier ... placementModifiers) {
        return ModTreeConfiguredFeatures.createPlacedFeatureDirect(feature, List.of(placementModifiers));
    }

    public static <FC extends FeatureConfiguration> Holder<PlacedFeature> createPlacedFeatureDirect(Holder<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> placementModifiers) {
        return Holder.direct((Object)new PlacedFeature(feature, placementModifiers));
    }

    public static void register() {
    }

    @FunctionalInterface
    public static interface ConfiguredFeatureFactory {
        public ConfiguredFeature<?, ?> generate(BootstrapContext<ConfiguredFeature<?, ?>> var1);
    }
}

