/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.worldgen.features;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.veroxuniverse.samurai_dynasty.worldgen.features.ModTreeConfiguredFeatures;

public class ModTreePlacedFeatures {
    public static final Map<ResourceKey<PlacedFeature>, PlacedFeatureFactory> PLACED_FEATURES_MOD = new Reference2ObjectOpenHashMap();
    public static final ResourceKey<PlacedFeature> SPIRIT_WOOD_TREES = ModTreePlacedFeatures.createPlacedFeature("spirit_wood_trees", ModTreeConfiguredFeatures.SPIRIT_WOOD_TREES, () -> VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)4, (float)0.25f, (int)2)));
    public static final ResourceKey<PlacedFeature> SPIRIT_BLOSSOM_TREES = ModTreePlacedFeatures.createPlacedFeature("spirit_blossom_trees", ModTreeConfiguredFeatures.SPIRIT_BLOSSOM_TREES, () -> VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)4, (float)0.25f, (int)2)));

    public static ResourceLocation createLocation(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"samurai_dynasty", (String)path);
    }

    @SafeVarargs
    private static ResourceKey<PlacedFeature> createPlacedFeature(String id, ResourceKey<ConfiguredFeature<?, ?>> feature, Supplier<PlacementModifier> ... placementModifiers) {
        return ModTreePlacedFeatures.createPlacedFeature(id, feature, () -> Arrays.stream(placementModifiers).map(Supplier::get).toList());
    }

    private static ResourceKey<PlacedFeature> createPlacedFeature(String id, ResourceKey<ConfiguredFeature<?, ?>> feature, Supplier<List<PlacementModifier>> placementModifiers) {
        ResourceLocation location = ModTreePlacedFeatures.createLocation(id);
        ResourceKey placedFeatureKey = ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)location);
        PLACED_FEATURES_MOD.put((ResourceKey<PlacedFeature>)placedFeatureKey, configuredFeatureHolderGetter -> new PlacedFeature((Holder)configuredFeatureHolderGetter.getOrThrow(feature), (List)placementModifiers.get()));
        return placedFeatureKey;
    }

    public static void register() {
    }

    @FunctionalInterface
    public static interface PlacedFeatureFactory {
        public PlacedFeature generate(HolderGetter<ConfiguredFeature<?, ?>> var1);
    }
}

