/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.samurai_dynasty.worldgen.features.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.veroxuniverse.samurai_dynasty.worldgen.features.decorators.ModDecoratorTypes;

public class LeavesAwareAttachedToLogsDecorator
extends TreeDecorator {
    public static final MapCodec<LeavesAwareAttachedToLogsDecorator> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(LeavesAwareAttachedToLogsDecorator::getProbability), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_xz").forGetter(LeavesAwareAttachedToLogsDecorator::getExclusionRadiusXZ), (App)Codec.intRange((int)0, (int)16).fieldOf("exclusion_radius_y").forGetter(LeavesAwareAttachedToLogsDecorator::getExclusionRadiusY), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(LeavesAwareAttachedToLogsDecorator::getBlockProvider), (App)Codec.intRange((int)1, (int)16).fieldOf("required_empty_blocks").forGetter(LeavesAwareAttachedToLogsDecorator::getRequiredEmptyBlocks), (App)ExtraCodecs.nonEmptyList((Codec)Direction.CODEC.listOf()).fieldOf("directions").forGetter(LeavesAwareAttachedToLogsDecorator::getDirections)).apply((Applicative)builder, LeavesAwareAttachedToLogsDecorator::new));
    protected final float probability;
    protected final int exclusionRadiusXZ;
    protected final int exclusionRadiusY;
    protected final BlockStateProvider blockProvider;
    protected final int requiredEmptyBlocks;
    protected final List<Direction> directions;

    public LeavesAwareAttachedToLogsDecorator(float probability, int exclusionRadiusXZ, int exclusionRadiusY, BlockStateProvider blockProvider, int requiredEmptyBlocks, List<Direction> directions) {
        this.probability = probability;
        this.exclusionRadiusXZ = exclusionRadiusXZ;
        this.exclusionRadiusY = exclusionRadiusY;
        this.blockProvider = blockProvider;
        this.requiredEmptyBlocks = requiredEmptyBlocks;
        this.directions = directions;
    }

    public void place(TreeDecorator.Context context) {
        HashSet<BlockPos> processedPositions = new HashSet<BlockPos>();
        RandomSource random = context.random();
        for (BlockPos logPos : Util.shuffledCopy((ObjectArrayList)context.logs(), (RandomSource)random)) {
            Direction direction;
            BlockPos relative = logPos.relative(direction = (Direction)Util.getRandom(this.directions, (RandomSource)random));
            if (processedPositions.contains(relative) || !(random.nextFloat() < this.probability) || !this.hasRequiredEmptyBlocks(context, logPos, direction, this.requiredEmptyBlocks)) continue;
            BlockPos above = relative.above();
            boolean isLeavesAbove = context.level().isStateAtPosition(above, state -> state.is(BlockTags.LEAVES));
            if (!isLeavesAbove) continue;
            BlockPos offsetMin = relative.offset(-this.exclusionRadiusXZ, -this.exclusionRadiusY, -this.exclusionRadiusXZ);
            BlockPos offsetMax = relative.offset(this.exclusionRadiusXZ, this.exclusionRadiusY, this.exclusionRadiusXZ);
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)offsetMin, (BlockPos)offsetMax)) {
                processedPositions.add(pos.immutable());
            }
            BlockState state2 = this.blockProvider.getState(random, relative);
            if (state2.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                state2 = (BlockState)state2.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)direction);
            }
            context.setBlock(relative, state2);
        }
    }

    private boolean hasRequiredEmptyBlocks(TreeDecorator.Context context, BlockPos pos, Direction direction, int requiredEmptyBlocks) {
        for (int i = 1; i <= requiredEmptyBlocks; ++i) {
            BlockPos checkPos = pos.relative(direction, i);
            if (context.isAir(checkPos)) continue;
            return false;
        }
        return true;
    }

    protected TreeDecoratorType<?> type() {
        return ModDecoratorTypes.LEAVES_ATTACHED_TO_LOGS.get();
    }

    public float getProbability() {
        return this.probability;
    }

    public int getExclusionRadiusXZ() {
        return this.exclusionRadiusXZ;
    }

    public int getExclusionRadiusY() {
        return this.exclusionRadiusY;
    }

    public BlockStateProvider getBlockProvider() {
        return this.blockProvider;
    }

    public int getRequiredEmptyBlocks() {
        return this.requiredEmptyBlocks;
    }

    public List<Direction> getDirections() {
        return this.directions;
    }
}

