/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.createbetterfps.renderer;

import com.moepus.createbetterfps.renderer.IrisCompat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.ColorAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.LightAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.NormalAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.OverlayAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.PositionAttribute;
import net.caffeinemc.mods.sodium.api.vertex.attributes.common.TextureAttribute;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.irisshaders.iris.vertices.IrisVertexFormats;
import org.lwjgl.system.MemoryUtil;

public class IrisEntityVertex {
    public static final VertexFormat FORMAT;
    public static final int STRIDE;
    public static final long ENTITY_ID_OFFSET;
    public static final long BLOCK_ENTITY_ID_OFFSET;
    public static final long ITEM_ID_OFFSET;
    public static final long MID_U_OFFSET;
    public static final long MID_V_OFFSET;
    public static final long TANGENT_OFFSET;

    public static void write(long ptr, float x, float y, float z, int color, float u, float v, float mid_u, float mid_v, int overlay, int light, int normal, int tangent) {
        PositionAttribute.put((long)(ptr + 0L), (float)x, (float)y, (float)z);
        ColorAttribute.set((long)(ptr + 12L), (int)color);
        TextureAttribute.put((long)(ptr + 16L), (float)u, (float)v);
        OverlayAttribute.set((long)(ptr + 24L), (int)overlay);
        LightAttribute.set((long)(ptr + 28L), (int)light);
        NormalAttribute.set((long)(ptr + 32L), (int)normal);
        MemoryUtil.memPutShort((long)(ptr + ENTITY_ID_OFFSET), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedEntity()));
        MemoryUtil.memPutShort((long)(ptr + BLOCK_ENTITY_ID_OFFSET), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedBlockEntity()));
        MemoryUtil.memPutShort((long)(ptr + ITEM_ID_OFFSET), (short)((short)CapturedRenderingState.INSTANCE.getCurrentRenderedItem()));
        MemoryUtil.memPutFloat((long)(ptr + MID_U_OFFSET), (float)mid_u);
        MemoryUtil.memPutFloat((long)(ptr + MID_V_OFFSET), (float)mid_v);
        MemoryUtil.memPutInt((long)(ptr + TANGENT_OFFSET), (int)tangent);
    }

    static {
        Object object = FORMAT = IrisCompat.IS_IRIS_INSTALLED ? IrisCompat.GetEntityVertexFormat() : null;
        if (FORMAT != null) {
            STRIDE = FORMAT.getVertexSize();
            ENTITY_ID_OFFSET = FORMAT.getOffset(IrisVertexFormats.ENTITY_ID_ELEMENT);
            BLOCK_ENTITY_ID_OFFSET = ENTITY_ID_OFFSET + 2L;
            ITEM_ID_OFFSET = BLOCK_ENTITY_ID_OFFSET + 2L;
            MID_U_OFFSET = FORMAT.getOffset(IrisVertexFormats.MID_TEXTURE_ELEMENT);
            MID_V_OFFSET = MID_U_OFFSET + 4L;
            TANGENT_OFFSET = FORMAT.getOffset(IrisVertexFormats.TANGENT_ELEMENT);
        } else {
            STRIDE = 54;
            ENTITY_ID_OFFSET = 36L;
            BLOCK_ENTITY_ID_OFFSET = 38L;
            ITEM_ID_OFFSET = 40L;
            MID_U_OFFSET = 42L;
            MID_V_OFFSET = 46L;
            TANGENT_OFFSET = 50L;
        }
    }
}

