/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.shdima.throwables;

import com.destroystokyo.paper.event.entity.ThrownEggHatchEvent;
import io.gitlab.shdima.throwables.ThrowableSpawnEggsKt;
import io.gitlab.shdima.throwables.dependencies.org.bstats.bukkit.Metrics;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u000eH\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/gitlab/shdima/throwables/ThrowableSpawnEggs;", "Lorg/bukkit/plugin/java/JavaPlugin;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "key", "Lorg/bukkit/NamespacedKey;", "onEnable", "", "initializeMetrics", "onThrowEgg", "event", "Lorg/bukkit/event/player/PlayerInteractEvent;", "onEggLand", "Lcom/destroystokyo/paper/event/entity/ThrownEggHatchEvent;", "isSpawnEgg", "", "item", "Lorg/bukkit/inventory/ItemStack;", "isThrowableEgg", "getEntityTypeFromEgg", "Lorg/bukkit/entity/EntityType;", "throwSpawnEgg", "player", "Lorg/bukkit/entity/Player;", "hand", "Lorg/bukkit/inventory/EquipmentSlot;", "calculateThrowVelocity", "Lorg/bukkit/util/Vector;", "markEggAsThrowable", "playThrowSound", "shouldConsumeItem", "spawnEggEntity", "egg", "Lorg/bukkit/entity/Egg;", "type", "throwable-spawn-eggs"})
@SourceDebugExtension(value={"SMAP\nThrowableSpawnEggs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThrowableSpawnEggs.kt\nio/gitlab/shdima/throwables/ThrowableSpawnEggs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,155:1\n295#2,2:156\n*S KotlinDebug\n*F\n+ 1 ThrowableSpawnEggs.kt\nio/gitlab/shdima/throwables/ThrowableSpawnEggs\n*L\n97#1:156,2\n*E\n"})
public final class ThrowableSpawnEggs
extends JavaPlugin
implements Listener {
    @NotNull
    private final NamespacedKey key = new NamespacedKey((Plugin)this, "throwable");

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.initializeMetrics();
    }

    private final void initializeMetrics() {
        try {
            new Metrics((Plugin)this, 27754);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @EventHandler
    private final void onThrowEgg(PlayerInteractEvent event) {
        if (!event.getAction().isRightClick()) {
            return;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        ItemStack itemStack = event.getItem();
        if (itemStack == null) {
            return;
        }
        ItemStack item = itemStack;
        if (!this.isSpawnEgg(item)) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        EquipmentSlot equipmentSlot = event.getHand();
        Intrinsics.checkNotNull((Object)equipmentSlot);
        this.throwSpawnEgg(player2, item, equipmentSlot);
        if (this.shouldConsumeItem(player2)) {
            int n = item.getAmount();
            item.setAmount(n + -1);
        }
        player2.swingMainHand();
        event.setCancelled(true);
    }

    @EventHandler
    private final void onEggLand(ThrownEggHatchEvent event) {
        Egg egg = event.getEgg();
        Intrinsics.checkNotNullExpressionValue((Object)egg, (String)"getEgg(...)");
        Egg entity = egg;
        ItemStack itemStack = entity.getItem();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItem(...)");
        ItemStack item = itemStack;
        if (!this.isThrowableEgg(item)) {
            return;
        }
        EntityType entityType = this.getEntityTypeFromEgg(item);
        if (entityType == null) {
            return;
        }
        EntityType entityType2 = entityType;
        this.spawnEggEntity(entity, entityType2);
        event.setNumHatches((byte)0);
        event.setHatching(false);
    }

    private final boolean isSpawnEgg(ItemStack item) {
        return StringsKt.endsWith$default((String)item.getType().toString(), (String)"_SPAWN_EGG", (boolean)false, (int)2, null);
    }

    private final boolean isThrowableEgg(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        SpawnEggMeta spawnEggMeta = itemMeta instanceof SpawnEggMeta ? (SpawnEggMeta)itemMeta : null;
        if (spawnEggMeta == null) {
            return false;
        }
        SpawnEggMeta meta = spawnEggMeta;
        return Intrinsics.areEqual((Object)meta.getPersistentDataContainer().get(this.key, PersistentDataType.BOOLEAN), (Object)true);
    }

    private final EntityType getEntityTypeFromEgg(ItemStack item) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = (Iterable)EntriesMappings.entries$0;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EntityType it = (EntityType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)item.getType().name(), (Object)(it.name() + "_SPAWN_EGG"))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final void throwSpawnEgg(Player player, ItemStack item, EquipmentSlot hand) {
        Vector velocity = this.calculateThrowVelocity(player);
        ItemStack markedItem = this.markEggAsThrowable(item);
        player.launchProjectile(Egg.class, velocity, arg_0 -> ThrowableSpawnEggs.throwSpawnEgg$lambda$2(arg_0 -> ThrowableSpawnEggs.throwSpawnEgg$lambda$1(markedItem, arg_0), arg_0));
        this.playThrowSound(player);
        player.swingHand(hand);
    }

    private final Vector calculateThrowVelocity(Player player) {
        Vector vector = player.getLocation().getDirection();
        Intrinsics.checkNotNullExpressionValue((Object)vector, (String)"getDirection(...)");
        Vector direction = vector;
        Vector vector2 = direction.add(new Vector(ThrowableSpawnEggsKt.access$triangle(0.0, 0.0172275), ThrowableSpawnEggsKt.access$triangle(0.0, 0.0172275), ThrowableSpawnEggsKt.access$triangle(0.0, 0.0172275))).multiply(1.5).add(player.getVelocity());
        Intrinsics.checkNotNullExpressionValue((Object)vector2, (String)"add(...)");
        return vector2;
    }

    private final ItemStack markEggAsThrowable(ItemStack item) {
        ItemStack itemStack;
        ItemStack itemStack2 = item.clone();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"clone(...)");
        ItemStack $this$markEggAsThrowable_u24lambda_u245 = itemStack = itemStack2;
        boolean bl = false;
        $this$markEggAsThrowable_u24lambda_u245.setAmount(1);
        $this$markEggAsThrowable_u24lambda_u245.editMeta(SpawnEggMeta.class, arg_0 -> ThrowableSpawnEggs.markEggAsThrowable$lambda$5$lambda$4(arg_0 -> ThrowableSpawnEggs.markEggAsThrowable$lambda$5$lambda$3(this, arg_0), arg_0));
        return itemStack;
    }

    private final void playThrowSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_EGG_THROW, SoundCategory.PLAYERS, 0.5f, 0.4f / (Random.Default.nextFloat() * 0.4f + 0.8f));
    }

    private final boolean shouldConsumeItem(Player player) {
        return player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR;
    }

    private final void spawnEggEntity(Egg egg, EntityType type) {
        egg.getWorld().spawnEntity(egg.getLocation(), type, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
    }

    private static final Unit throwSpawnEgg$lambda$1(ItemStack $markedItem, Egg it) {
        it.setItem($markedItem);
        return Unit.INSTANCE;
    }

    private static final void throwSpawnEgg$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit markEggAsThrowable$lambda$5$lambda$3(ThrowableSpawnEggs this$0, SpawnEggMeta it) {
        it.getPersistentDataContainer().set(this$0.key, PersistentDataType.BOOLEAN, (Object)true);
        return Unit.INSTANCE;
    }

    private static final void markEggAsThrowable$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<EntityType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])EntityType.values()));
        }
    }
}

