/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.client;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.NotNull;
import su.terrafirmagreg.core.common.data.TFGBlocks;
import su.terrafirmagreg.core.common.data.TFGContainers;
import su.terrafirmagreg.core.common.data.TFGFluids;
import su.terrafirmagreg.core.common.data.TFGParticles;
import su.terrafirmagreg.core.common.data.capabilities.ILargeEgg;
import su.terrafirmagreg.core.common.data.capabilities.LargeEggCapability;
import su.terrafirmagreg.core.common.data.container.LargeNestBoxScreen;
import su.terrafirmagreg.core.common.data.events.AdvancedOreProspectorEventHelper;
import su.terrafirmagreg.core.common.data.events.NormalOreProspectorEventHelper;
import su.terrafirmagreg.core.common.data.events.OreProspectorEvent;
import su.terrafirmagreg.core.common.data.events.WeakOreProspectorEventHelper;
import su.terrafirmagreg.core.common.data.particles.ColoredWindParticleProvider;
import su.terrafirmagreg.core.common.data.particles.CoolingSteamProvider;
import su.terrafirmagreg.core.common.data.particles.OreProspectorProvider;
import su.terrafirmagreg.core.common.data.particles.OreProspectorVeinProvider;
import su.terrafirmagreg.core.common.data.particles.RailgunAmmoProvider;
import su.terrafirmagreg.core.common.data.particles.RailgunBoomProvider;

@Mod.EventBusSubscriber(modid="tfg", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class TFGClientEventHandler {
    public static final ResourceLocation TFCMetalBlockTexturePattern = ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"block/metal/smooth_pattern");

    public TFGClientEventHandler() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        bus.addListener(TFGClientEventHandler::clientSetup);
        bus.addListener(TFGClientEventHandler::registerSpecialModels);
        forgeBus.addListener(TFGClientEventHandler::onItemTooltip);
        bus.register((Object)this);
    }

    @SubscribeEvent
    public static void onTooltip(@NotNull ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        for (WeakOreProspectorEventHelper weakOreProspectorEventHelper : OreProspectorEvent.getWeakOreProspectorListHelper()) {
            if (!stack.m_204117_(weakOreProspectorEventHelper.getItemTag())) continue;
            tooltip.add(Component.m_237110_((String)"tfg.tooltip.ore_prospector_stats", (Object[])new Object[]{weakOreProspectorEventHelper.getLength(), (int)(weakOreProspectorEventHelper.getHalfWidth() * 2.0), (int)(weakOreProspectorEventHelper.getHalfHeight() * 2.0)}).m_130940_(ChatFormatting.YELLOW));
            return;
        }
        for (NormalOreProspectorEventHelper normalOreProspectorEventHelper : OreProspectorEvent.getNormalOreProspectorListHelper()) {
            if (!stack.m_204117_(normalOreProspectorEventHelper.getItemTag())) continue;
            tooltip.add(Component.m_237110_((String)"tfg.tooltip.ore_prospector_stats", (Object[])new Object[]{normalOreProspectorEventHelper.getLength(), (int)(normalOreProspectorEventHelper.getHalfWidth() * 2.0), (int)(normalOreProspectorEventHelper.getHalfHeight() * 2.0)}).m_130940_(ChatFormatting.YELLOW));
            tooltip.add(Component.m_237115_((String)"tfg.tooltip.ore_prospector_count").m_130940_(ChatFormatting.YELLOW));
            return;
        }
        for (AdvancedOreProspectorEventHelper advancedOreProspectorEventHelper : OreProspectorEvent.getAdvancedOreProspectorListHelper()) {
            if (!stack.m_204117_(advancedOreProspectorEventHelper.getItemTag())) continue;
            String modeKey = advancedOreProspectorEventHelper.isCentersOnly() ? "tfg.tooltip.ore_prospector_mode_vein" : "tfg.tooltip.ore_prospector_mode_block";
            tooltip.add(Component.m_237110_((String)"tfg.tooltip.ore_prospector_stats", (Object[])new Object[]{advancedOreProspectorEventHelper.getLength(), (int)(advancedOreProspectorEventHelper.getHalfWidth() * 2.0), (int)(advancedOreProspectorEventHelper.getHalfHeight() * 2.0)}).m_130940_(ChatFormatting.YELLOW));
            tooltip.add(Component.m_237115_((String)"tfg.tooltip.ore_prospector_count").m_130940_(ChatFormatting.YELLOW));
            tooltip.add(Component.m_237110_((String)"tfg.tooltip.ore_prospector_xray", (Object[])new Object[]{Component.m_237115_((String)modeKey)}).m_130940_(ChatFormatting.YELLOW));
            return;
        }
    }

    @SubscribeEvent
    public void registerParticles(@NotNull RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)TFGParticles.RAILGUN_BOOM.get(), RailgunBoomProvider::new);
        event.registerSpriteSet((ParticleType)TFGParticles.RAILGUN_AMMO.get(), RailgunAmmoProvider::new);
        event.registerSpriteSet((ParticleType)TFGParticles.ORE_PROSPECTOR.get(), OreProspectorProvider::new);
        event.registerSpriteSet((ParticleType)TFGParticles.ORE_PROSPECTOR_VEIN.get(), OreProspectorVeinProvider::new);
        event.registerSpriteSet((ParticleType)TFGParticles.COOLING_STEAM.get(), CoolingSteamProvider::new);
        event.registerSpriteSet((ParticleType)TFGParticles.DARK_MARS_WIND.get(), set -> new ColoredWindParticleProvider(set, 12477985));
        event.registerSpriteSet((ParticleType)TFGParticles.MEDIUM_MARS_WIND.get(), set -> new ColoredWindParticleProvider(set, 12878934));
        event.registerSpriteSet((ParticleType)TFGParticles.LIGHT_MARS_WIND.get(), set -> new ColoredWindParticleProvider(set, 13606745));
    }

    public static void clientSetup(FMLClientSetupEvent evt) {
        evt.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)TFGContainers.LARGE_NEST_BOX.get()), LargeNestBoxScreen::new);
            ItemBlockRenderTypes.setRenderLayer((Fluid)TFGFluids.MARS_WATER.getFlowing(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)TFGFluids.MARS_WATER.getSource(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)TFGFluids.SULFUR_FUMES.getFlowing(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)TFGFluids.SULFUR_FUMES.getSource(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)TFGFluids.GEYSER_SLURRY.getFlowing(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)TFGFluids.GEYSER_SLURRY.getSource(), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFGBlocks.MARS_ICE.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFGBlocks.MARS_ICICLE.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFGBlocks.DRY_ICE.get()), (RenderType)RenderType.m_110466_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)TFGBlocks.REFLECTOR_BLOCK.get()), (RenderType)RenderType.m_110466_());
        });
    }

    private static void registerSpecialModels(ModelEvent.RegisterAdditional event) {
        event.register(ResourceLocation.fromNamespaceAndPath((String)"tfc", (String)"block/metal/smooth_pattern"));
    }

    private static void onItemTooltip(ItemTooltipEvent event) {
        ILargeEgg egg;
        ItemStack stack = event.getItemStack();
        List text = event.getToolTip();
        if (!stack.m_41619_() && (egg = LargeEggCapability.get(stack)) != null) {
            egg.addTooltipInfo(text);
        }
    }

    @SubscribeEvent
    public void modConstruct(FMLConstructModEvent event) {
    }
}

