/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data;

import java.util.function.Consumer;
import java.util.function.Function;
import net.dries007.tfc.common.fluids.ExtendedFluidType;
import net.dries007.tfc.common.fluids.FluidRegistryObject;
import net.dries007.tfc.common.fluids.FluidTypeClientProperties;
import net.dries007.tfc.common.fluids.MixingFluid;
import net.dries007.tfc.common.fluids.TFCFluids;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import su.terrafirmagreg.core.common.data.TFGBlocks;
import su.terrafirmagreg.core.common.data.TFGItems;

public class TFGFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((ResourceKey)Registries.f_256808_, (String)"tfg");
    public static final FluidRegistryObject<ForgeFlowingFluid> MARS_WATER = TFGFluids.register("semiheavy_ammoniacal_water", properties -> properties.block(TFGBlocks.MARS_WATER).bucket(TFGItems.MARS_WATER_BUCKET), TFGFluids.waterLike().temperature(213).descriptionId("fluid.tfg.semiheavy_ammoniacal_water"), new FluidTypeClientProperties(-11150927, TFCFluids.WATER_STILL, TFCFluids.WATER_FLOW, TFCFluids.WATER_OVERLAY, TFCFluids.UNDERWATER_LOCATION), MixingFluid.Source::new, MixingFluid.Flowing::new);
    public static final FluidRegistryObject<ForgeFlowingFluid> SULFUR_FUMES = TFGFluids.register("sulfur_fumes", properties -> properties.block(TFGBlocks.SULFUR_FUMES).bucket(TFGItems.SULFUR_FUMES_BUCKET), TFGFluids.gasLike().temperature(737).viscosity(0).density(0).descriptionId("fluid.tfg.sulfur_fumes"), new FluidTypeClientProperties(-1, ResourceLocation.fromNamespaceAndPath((String)"tfg", (String)"block/planets/venus/sulfur_fumes_still"), ResourceLocation.fromNamespaceAndPath((String)"tfg", (String)"block/planets/venus/sulfur_fumes_flow"), null, null), MixingFluid.Source::new, MixingFluid.Flowing::new);
    public static final FluidRegistryObject<ForgeFlowingFluid> GEYSER_SLURRY = TFGFluids.register("geyser_slurry", properties -> properties.block(TFGBlocks.GEYSER_SLURRY).bucket(TFGItems.GEYSER_SLURRY_BUCKET), FluidType.Properties.create().adjacentPathType(BlockPathTypes.LAVA).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).density(3000).viscosity(6000).canConvertToSource(false).canExtinguish(true).canHydrate(false).supportsBoating(false).canDrown(true).canSwim(true).temperature(1300).canPushEntity(true).descriptionId("fluid.tfg.geyser_slurry"), new FluidTypeClientProperties(-1, ResourceLocation.fromNamespaceAndPath((String)"tfg", (String)"block/planets/venus/geyser_slurry_still"), ResourceLocation.fromNamespaceAndPath((String)"tfg", (String)"block/planets/venus/geyser_slurry_flow"), null, null), MixingFluid.Source::new, MixingFluid.Flowing::new);

    private static FluidType.Properties waterLike() {
        return FluidType.Properties.create().adjacentPathType(BlockPathTypes.WATER).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).canConvertToSource(true).canDrown(true).canExtinguish(true).canHydrate(true).canPushEntity(true).canSwim(true).supportsBoating(true);
    }

    private static FluidType.Properties gasLike() {
        return FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).canConvertToSource(true).canDrown(false).canExtinguish(false).canHydrate(false).canPushEntity(false).canSwim(false).supportsBoating(false);
    }

    private static <F extends FlowingFluid> FluidRegistryObject<F> register(String name, Consumer<ForgeFlowingFluid.Properties> builder, FluidType.Properties typeProperties, FluidTypeClientProperties clientProperties, Function<ForgeFlowingFluid.Properties, F> sourceFactory, Function<ForgeFlowingFluid.Properties, F> flowingFactory) {
        int index = name.lastIndexOf(47);
        String flowingName = index == -1 ? "flowing_" + name : name.substring(0, index) + "/flowing_" + name.substring(index + 1);
        return RegistrationHelpers.registerFluid((DeferredRegister)TFCFluids.FLUID_TYPES, FLUIDS, (String)name, (String)name, (String)flowingName, builder, () -> new ExtendedFluidType(typeProperties, clientProperties), sourceFactory, flowingFactory);
    }
}

