/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.blockentity;

import javax.annotation.Nullable;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.blockentities.TickableInventoryBlockEntity;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.entities.misc.Seat;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.INBTSerializable;
import su.terrafirmagreg.core.common.data.TFGBlockEntities;
import su.terrafirmagreg.core.common.data.blocks.LargeNestBoxBlock;
import su.terrafirmagreg.core.common.data.capabilities.ILargeEgg;
import su.terrafirmagreg.core.common.data.capabilities.LargeEggCapability;
import su.terrafirmagreg.core.common.data.container.LargeNestBoxContainer;
import su.terrafirmagreg.core.common.data.entities.TFGWoolEggProducingAnimal;

public class LargeNestBoxBlockEntity
extends TickableInventoryBlockEntity<LargeNestBoxInventory> {
    public static final int SLOTS = 4;
    private static final Component NAME = Component.m_237115_((String)"tfg.block_entity.large_nest_box");

    public static void serverTick(Level level, BlockPos pos, BlockState state, LargeNestBoxBlockEntity nest) {
        nest.checkForLastTickSync();
        if (level.m_46467_() % 30L == 0L) {
            if (!(state.m_60734_() instanceof LargeNestBoxBlock)) {
                return;
            }
            Entity sitter = Seat.getSittingEntity((Level)level, (BlockPos)pos);
            if (sitter instanceof TFGWoolEggProducingAnimal) {
                TFGWoolEggProducingAnimal animal = (TFGWoolEggProducingAnimal)sitter;
                if (animal.isReadyForAnimalProduct()) {
                    BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
                    Direction backward = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
                    Direction left = backward.m_122427_();
                    switch ((Integer)state.m_61143_((Property)LargeNestBoxBlock.NEST_PART)) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            cursor.m_122173_(backward);
                            break;
                        }
                        case 2: {
                            cursor.m_122173_(left);
                            break;
                        }
                        case 3: {
                            cursor.m_122173_(backward).m_122173_(left);
                        }
                    }
                    if (animal.m_217043_().m_188503_(7) == 0) {
                        Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11752_);
                        if (Helpers.insertOne((Level)level, (BlockPos)cursor, (BlockEntityType)((BlockEntityType)TFGBlockEntities.LARGE_NEST_BOX.get()), (ItemStack)animal.makeEgg())) {
                            animal.setFertilized(false);
                            animal.setProductsCooldown();
                            animal.m_8127_();
                            nest.markForSync();
                        }
                    }
                } else {
                    animal.m_8127_();
                }
            }
            for (int slot = 0; slot < ((LargeNestBoxInventory)nest.inventory).getSlots(); ++slot) {
                ItemStack stack = ((LargeNestBoxInventory)nest.inventory).getStackInSlot(slot);
                ILargeEgg egg = LargeEggCapability.get(stack);
                if (egg == null || egg.getHatchDay() <= 0L || egg.getHatchDay() > Calendars.SERVER.getTotalDays()) continue;
                egg.getEntity(level).ifPresent(entity -> {
                    entity.m_20035_(pos, 0.0f, 0.0f);
                    level.m_7967_(entity);
                });
                ((LargeNestBoxInventory)nest.inventory).setStackInSlot(slot, ItemStack.f_41583_);
            }
        }
    }

    public LargeNestBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFGBlockEntities.LARGE_NEST_BOX.get(), pos, state, LargeNestBoxInventory::new, NAME);
        if (((Boolean)TFCConfig.SERVER.nestBoxEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).extractAll(), new Direction[]{Direction.DOWN});
        }
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.mightHaveCapability((ItemStack)stack, LargeEggCapability.CAPABILITY);
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory inv, Player player) {
        return LargeNestBoxContainer.create(this, inv, windowID);
    }

    public static class LargeNestBoxInventory
    extends InventoryItemHandler
    implements INBTSerializable<CompoundTag> {
        private final InventoryBlockEntity<?> entity;

        LargeNestBoxInventory(InventoryBlockEntity<?> entity) {
            super(entity, 4);
            this.entity = entity;
        }

        public int getSlotStackLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return Helpers.mightHaveCapability((ItemStack)stack, LargeEggCapability.CAPABILITY);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            Level level = this.entity.m_58904_();
            BlockState state = this.entity.m_58900_();
            BlockPos pos = this.entity.m_58899_();
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos().m_122190_((Vec3i)pos);
            Direction forward = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            Direction right = forward.m_122427_();
            for (int i = 0; i < this.getSlots(); ++i) {
                int newEggState = 0;
                ItemStack stack = this.getStackInSlot(slot);
                if (!stack.m_41619_()) {
                    newEggState = switch (stack.m_41720_().toString()) {
                        case "sniffer_egg" -> 1;
                        case "wraptor_egg" -> 2;
                        default -> newEggState;
                    };
                }
                switch (slot) {
                    case 0: {
                        cursor.m_122173_(forward);
                        break;
                    }
                    case 1: {
                        cursor.m_122173_(forward).m_122173_(right);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        cursor.m_122173_(right);
                    }
                }
                if (!(level.m_8055_((BlockPos)cursor).m_60734_() instanceof LargeNestBoxBlock)) break;
                int eggState = (Integer)level.m_8055_((BlockPos)cursor).m_61143_((Property)LargeNestBoxBlock.HAS_EGG_TYPE);
                if (eggState == newEggState) continue;
                BlockState targetState = level.m_8055_((BlockPos)cursor);
                level.m_46597_((BlockPos)cursor, (BlockState)targetState.m_61124_((Property)LargeNestBoxBlock.HAS_EGG_TYPE, (Comparable)Integer.valueOf(newEggState)));
            }
        }
    }
}

