/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.blocks;

import java.util.Optional;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.PileBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.common.data.TFGBlocks;
import su.terrafirmagreg.core.common.data.blocks.SandLayerBlock;
import su.terrafirmagreg.core.utils.PlanetEnvironmentalHelpers;

public class SandPileBlock
extends SandLayerBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    private final ExtendedProperties properties;

    public static boolean canPlaceSandPile(LevelAccessor level, BlockPos pos, BlockState state) {
        return Helpers.isBlock((Block)state.m_60734_(), (TagKey)TFCTags.Blocks.CAN_BE_SNOW_PILED) && ((SandPileBlock)((Object)TFGBlocks.MARS_SAND_PILE_BLOCK.get())).m_49966_().m_60710_((LevelReader)level, pos);
    }

    public static void placeSandPile(LevelAccessor level, BlockPos pos, BlockState state, boolean byPlayer) {
        BlockPos posAbove = pos.m_7494_();
        BlockState aboveState = level.m_8055_(posAbove);
        BlockState savedAboveState = Helpers.isBlock((Block)aboveState.m_60734_(), (TagKey)TFCTags.Blocks.CAN_BE_SNOW_PILED) ? aboveState : null;
        BlockState sandPile = PlanetEnvironmentalHelpers.getSandBlockForBiome((LevelReader)level, pos).m_49966_();
        level.m_7731_(pos, sandPile, 18);
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PILE.get()).ifPresent(entity -> entity.setHiddenStates(state, savedAboveState, byPlayer));
        if (savedAboveState != null) {
            Helpers.removeBlock((LevelAccessor)level, (BlockPos)posAbove, (int)18);
        }
        level.m_6289_(pos, (Block)TFCBlocks.SNOW_PILE.get());
        if (savedAboveState != null) {
            level.m_6289_(posAbove, Blocks.f_50016_);
        }
    }

    public static void removePileOrSand(LevelAccessor level, BlockPos pos, BlockState state) {
        SandPileBlock.removePileOrSand(level, pos, state, -1);
    }

    public static void removePileOrSand(LevelAccessor level, BlockPos pos, BlockState state, int expectedLayers) {
        SandPileBlock.removePileOrSand(level, pos, state, expectedLayers, null);
    }

    public static void removePileOrSand(LevelAccessor level, BlockPos pos, BlockState state, int expectedLayers, @Nullable Optional<PileBlockEntity> sandPile) {
        int layers = (Integer)state.m_61143_((Property)SandLayerBlock.f_56581_);
        if (expectedLayers >= layers) {
            return;
        }
        if (layers > 1 && expectedLayers != 0) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)SandLayerBlock.f_56581_, (Comparable)Integer.valueOf(expectedLayers == -1 ? layers - 1 : expectedLayers)), 3);
        } else {
            if (sandPile == null) {
                sandPile = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.PILE.get());
            }
            sandPile.ifPresent(pile -> {
                BlockPos above = pos.m_7494_();
                level.m_7731_(pos, pile.getInternalState(), 18);
                if (pile.getAboveState() != null && level.m_46859_(above)) {
                    level.m_7731_(above, pile.getAboveState(), 18);
                }
                pile.getInternalState().m_60701_(level, pos, 2);
                level.m_8055_(above).m_60701_(level, above, 2);
                level.m_6289_(pos, pile.getInternalState().m_60734_());
                if (pile.getAboveState() != null) {
                    level.m_6289_(above, pile.getAboveState().m_60734_());
                }
            });
        }
    }

    public SandPileBlock(ExtendedProperties properties) {
        super(properties.properties());
        this.properties = properties;
    }

    public ExtendedProperties getExtendedProperties() {
        return this.properties;
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity entity, ItemStack stack) {
        Optional<PileBlockEntity> optional;
        super.m_6240_(level, player, pos, state, entity, stack);
        if (entity instanceof PileBlockEntity) {
            PileBlockEntity pile = (PileBlockEntity)entity;
            optional = Optional.of(pile);
        } else {
            optional = Optional.empty();
        }
        SandPileBlock.removePileOrSand((LevelAccessor)level, pos, state, -1, optional);
    }

    @Override
    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        this.m_5707_(level, pos, state, player);
        SandPileBlock.removePileOrSand((LevelAccessor)level, pos, state);
        return true;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return true;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.m_49966_();
    }
}

