/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.entities.wraptor;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.ninni.species.registry.SpeciesSoundEvents;
import java.util.List;
import java.util.function.IntFunction;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.livestock.ProducingAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.animals.ProducingAnimalConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.common.data.TFGItems;
import su.terrafirmagreg.core.common.data.TFGTags;
import su.terrafirmagreg.core.common.data.capabilities.ILargeEgg;
import su.terrafirmagreg.core.common.data.capabilities.LargeEggCapability;
import su.terrafirmagreg.core.common.data.entities.TFGWoolEggProducingAnimal;
import su.terrafirmagreg.core.common.data.entities.wraptor.TFCWraptorAi;

public class TFCWraptor
extends TFGWoolEggProducingAnimal
implements IForgeShearable {
    static double familiarityCap = 0.35;
    static int adulthoodDays = 45;
    static int uses = 100;
    static boolean eatsRottenFood = false;
    static int produceTicks = 48000;
    static int hatchDays = 10;
    static Item eggItem = (Item)TFGItems.WRAPTOR_EGG.get();
    static int woolProduceTicks = 48000;
    static int maxWool = 12;
    static Item woolItem = (Item)TFGItems.WRAPTOR_WOOL.get();
    static double produceFamiliarity = 0.15;
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(TFCWraptor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState roarAnimationState = new AnimationState();
    public final AnimationState fallingAnimationState = new AnimationState();

    public TFCWraptor(EntityType<? extends TFCAnimal> type, Level level, TFCSounds.EntitySound sounds, ProducingAnimalConfig config) {
        super(type, level, sounds, config);
    }

    public static TFCWraptor makeTFCWraptor(EntityType<? extends ProducingAnimal> type, Level level) {
        return new TFCWraptor(type, level, TFCSounds.CHICKEN, TFCConfig.SERVER.duckConfig.inner());
    }

    @NotNull
    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22278_, 0.25);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)WraptorVariant.DEFAULT.id);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("WraptorVariant", this.getVariant().id);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(WraptorVariant.byId(tag.m_128451_("WraptorVariant")));
    }

    public static boolean spawnRules(EntityType<? extends TFCWraptor> type, LevelAccessor level, MobSpawnType spawn, BlockPos pos, RandomSource rand) {
        return level.m_8055_(pos).m_60795_();
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData, CompoundTag tag) {
        spawnData = super.m_6518_(level, difficulty, reason, spawnData, tag);
        this.setVariant(this.getRandomWraptorType());
        return spawnData;
    }

    public float getAdultFamiliarityCap() {
        return (float)familiarityCap;
    }

    public int getDaysToAdulthood() {
        return adulthoodDays;
    }

    public int getUsesToElderly() {
        return uses;
    }

    public boolean eatsRottenFood() {
        return eatsRottenFood;
    }

    public boolean isReadyForAnimalProduct() {
        return (double)this.getFamiliarity() > produceFamiliarity && this.hasProduct();
    }

    public long getProductsCooldown() {
        return Math.max(0L, (long)produceTicks + this.getProducedTick() - Calendars.get((LevelReader)this.m_9236_()).getTicks());
    }

    public float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.95f;
    }

    public TagKey<Item> getFoodTag() {
        return TFGTags.Items.WraptorFood;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SpeciesSoundEvents.WRAPTOR_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)SpeciesSoundEvents.WRAPTOR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SpeciesSoundEvents.WRAPTOR_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SpeciesSoundEvents.WRAPTOR_STEP.get(), 0.15f, 1.0f);
    }

    public boolean hasProduct() {
        return (this.getProducedTick() <= 0L || this.getProductsCooldown() <= 0L) && this.getAgeType() == TFCAnimalProperties.Age.ADULT && (this.getGender() == TFCAnimalProperties.Gender.FEMALE || this.getGender() == TFCAnimalProperties.Gender.MALE && this.isFertilized());
    }

    public AgeableMob m_142606_(ServerLevel level, AgeableMob other) {
        if (other != this && this.getGender() == TFCAnimalProperties.Gender.FEMALE && other instanceof TFCWraptor) {
            TFCWraptor otherFertile = (TFCWraptor)other;
            if (!this.isFertilized()) {
                this.onFertilized(otherFertile);
                otherFertile.setProducedTick(0L);
                this.setProductsCooldown();
            }
        }
        return null;
    }

    public void onFertilized(TFCWraptor male) {
        male.setFertilized(true);
        male.setLastFed(this.getLastFed() - 1L);
        this.setLastFed(this.getLastFed() - 1L);
        male.addUses(5);
        this.addUses(5);
    }

    @Override
    public ItemStack makeEgg() {
        AnimalProductEvent event;
        ILargeEgg egg;
        ItemStack stack = new ItemStack((ItemLike)eggItem);
        if (this.isFertilized() && (egg = LargeEggCapability.get(stack)) != null) {
            TFCWraptor baby = (TFCWraptor)this.m_6095_().m_20615_(this.m_9236_());
            if (baby != null) {
                baby.setGender(TFCAnimalProperties.Gender.valueOf((boolean)this.f_19796_.m_188499_()));
                baby.setBirthDay(Calendars.SERVER.getTotalDays());
                baby.setFamiliarity(this.getFamiliarity() < 0.9f ? this.getFamiliarity() / 2.0f : this.getFamiliarity() * 0.9f);
                egg.setFertilized((Entity)baby, Calendars.SERVER.getTotalDays() + (long)hatchDays);
            } else {
                System.out.println("Cannot Create Child");
            }
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)(event = new AnimalProductEvent(this.m_9236_(), this.m_20183_(), null, (TFCAnimalProperties)this, stack, ItemStack.f_41583_, 1)))) {
            this.addUses(event.getUses());
        }
        return event.getProduct();
    }

    public MutableComponent getProductReadyName() {
        return Component.m_237115_((String)"tfc.jade.product.eggs");
    }

    public boolean isShearable(@NotNull ItemStack item, Level level, BlockPos pos) {
        return this.isReadyForWoolProduct();
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level level, BlockPos pos, int fortune) {
        this.setWoolCooldown();
        this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
        AnimalProductEvent event = new AnimalProductEvent(level, pos, player, (TFCAnimalProperties)this, this.getWoolItem(woolItem, maxWool), item, 1);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            this.addUses(event.getUses());
        }
        return List.of(event.getProduct());
    }

    public int getFeatherStage() {
        int usesLeft = this.getUsesToElderly();
        return this.hasWoolProduct(woolProduceTicks) ? 6 * (usesLeft / uses) : 0;
    }

    public boolean isReadyForWoolProduct() {
        return (double)this.getFamiliarity() > produceFamiliarity && this.hasWoolProduct(woolProduceTicks);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Brain.Provider<? extends TFCWraptor> m_5490_() {
        return Brain.m_21923_(TFCWraptorAi.MEMORY_TYPES, TFCWraptorAi.SENSOR_TYPES);
    }

    @NotNull
    public Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        return TFCWraptorAi.makeWraptorBrain((Brain<? extends TFCWraptor>)this.m_5490_().m_22073_(dynamic));
    }

    public WraptorVariant getVariant() {
        return WraptorVariant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(WraptorVariant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    private WraptorVariant getRandomWraptorType() {
        int rand = this.f_19796_.m_216332_(0, 49);
        if (rand == 0) {
            return WraptorVariant.TRANS;
        }
        if (rand == 1) {
            return WraptorVariant.GOTH;
        }
        return WraptorVariant.DEFAULT;
    }

    public static enum WraptorVariant implements StringRepresentable
    {
        DEFAULT(0, "default"),
        TRANS(1, "trans"),
        GOTH(2, "goth");

        private static final IntFunction<WraptorVariant> BY_ID;
        public static final Codec<WraptorVariant> CODEC;
        final int id;
        private final String name;

        private WraptorVariant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public int id() {
            return this.id;
        }

        public static WraptorVariant byId(int id) {
            return BY_ID.apply(id);
        }

        static {
            BY_ID = ByIdMap.m_262845_(WraptorVariant::id, (Object[])WraptorVariant.values(), (Object)((Object)DEFAULT));
            CODEC = StringRepresentable.m_216439_(WraptorVariant::values);
        }
    }
}

