/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.events;

import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import su.terrafirmagreg.core.common.data.TFGTags;
import su.terrafirmagreg.core.config.TFGConfig;

public class HarvesterEvent {
    private static final TagKey<Item> HARVESTER_ITEM_TAG = TFGTags.Items.Harvester;
    private static final TagKey<Block> HARVESTABLE_BLOCK_TAG = TFGTags.Blocks.HarvesterHarvestable;

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level.m_5776_()) {
            return;
        }
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack held = player.m_21120_(hand);
        BlockPos clickedPos = event.getPos();
        BlockState clickedState = level.m_8055_(clickedPos);
        if (!held.m_204117_(HARVESTER_ITEM_TAG)) {
            return;
        }
        if (!clickedState.m_204336_(HARVESTABLE_BLOCK_TAG)) {
            return;
        }
        int radius = (Integer)TFGConfig.SERVER.HARVEST_BASKET_RANGE.get();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(clickedPos);
        while (!queue.isEmpty()) {
            BlockState state;
            BlockPos current = (BlockPos)queue.poll();
            if (!visited.add(current) || !(state = level.m_8055_(current)).m_204336_(HARVESTABLE_BLOCK_TAG)) continue;
            BlockHitResult hit = new BlockHitResult(Vec3.m_82512_((Vec3i)current), Direction.UP, current, false);
            InteractionResult result = state.m_60664_(level, player, hand, hit);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos neighbor;
                        if (dx == 0 && dy == 0 && dz == 0 || !(neighbor = current.m_7918_(dx, dy, dz)).m_123314_((Vec3i)clickedPos, (double)radius)) continue;
                        queue.add(neighbor);
                    }
                }
            }
        }
        if (player instanceof ServerPlayer) {
            player.m_21011_(hand, true);
            level.m_5594_(null, clickedPos, SoundEvents.f_11678_, SoundSource.PLAYERS, 2.0f, 0.2f);
            held.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        }
        event.setCanceled(true);
    }
}

