/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.items;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import com.gregtechceu.gtceu.api.item.component.ElectricStats;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripInteractionPacket;
import com.simibubi.create.content.equipment.extendoGrip.ExtendoGripItemRenderer;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import su.terrafirmagreg.core.common.data.TFGItems;

@Mod.EventBusSubscriber
public class ElectricExtendoGrip
extends ComponentItem {
    public static final int COST = 8;
    public ElectricStats electricStats = ElectricStats.createElectricItem((long)1000000L, (int)2);
    public static final AttributeModifier singleRangeAttributeModifier = new AttributeModifier(UUID.fromString("604b1f96-e250-4674-9289-cca738a59460"), "Electric Extendo Grip Range modifier", 4.0, AttributeModifier.Operation.ADDITION);
    public static final AttributeModifier doubleRangeAttributeModifier = new AttributeModifier(UUID.fromString("704b1f96-e250-4674-9289-cca738a59460"), "Duel Electric Extendo Grip Range modifier", 6.0, AttributeModifier.Operation.ADDITION);
    private static final Supplier<Multimap<Attribute, AttributeModifier>> rangeModifier = Suppliers.memoize(() -> ImmutableMultimap.of((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)singleRangeAttributeModifier));
    private static final Supplier<Multimap<Attribute, AttributeModifier>> doubleRangeModifier = Suppliers.memoize(() -> ImmutableMultimap.of((Object)((Attribute)ForgeMod.BLOCK_REACH.get()), (Object)doubleRangeAttributeModifier));
    private static DamageSource lastActiveDamageSource;
    public static final String EXTENDO_MARKER = "electricExtendo";
    public static final String DUAL_EXTENDO_MARKER = "electricDualExtendo";

    public ElectricExtendoGrip(Item.Properties properties) {
        super(properties.m_41499_(200));
        this.attachComponents((IItemComponent)this.electricStats);
    }

    public static void clearMarkersIfNotInInventory(Player player) {
        boolean containsEEG = false;
        CompoundTag persistentData = player.getPersistentData();
        boolean hasEitherEEGMarker = persistentData.m_128441_(EXTENDO_MARKER) || persistentData.m_128441_(DUAL_EXTENDO_MARKER);
        for (ItemStack i : player.f_36095_.m_38927_()) {
            if (!(i.m_41720_() instanceof ElectricExtendoGrip)) continue;
            containsEEG = true;
        }
        if (!containsEEG && hasEitherEEGMarker) {
            player.m_21204_().m_22161_(rangeModifier.get());
            persistentData.m_128473_(EXTENDO_MARKER);
            player.m_21204_().m_22161_(doubleRangeModifier.get());
            persistentData.m_128473_(DUAL_EXTENDO_MARKER);
        }
    }

    @SubscribeEvent
    public static void holdingExtendoGripIncreasesRange(LivingEvent.LivingTickEvent event) {
        IElectricItem currentElectric;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CompoundTag persistentData = player.getPersistentData();
        boolean inOff = player.m_21206_().m_150930_((Item)TFGItems.ELECTRIC_EXTENDO_GRIP.get());
        boolean inMain = player.m_21205_().m_150930_((Item)TFGItems.ELECTRIC_EXTENDO_GRIP.get());
        boolean holdingDualExtendo = inOff && inMain;
        boolean holdingExtendo = inOff ^ inMain;
        holdingExtendo &= !holdingDualExtendo;
        boolean wasHoldingExtendo = persistentData.m_128441_(EXTENDO_MARKER);
        boolean wasHoldingDualExtendo = persistentData.m_128441_(DUAL_EXTENDO_MARKER);
        ElectricExtendoGrip.clearMarkersIfNotInInventory(player);
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        ItemStack currentHand = null;
        long currentCharge = 0L;
        if (holdingExtendo && (currentElectric = GTCapabilityHelper.getElectricItem((ItemStack)(currentHand = mainHand.m_41720_() instanceof ElectricExtendoGrip ? mainHand : offHand))) != null) {
            currentElectric.discharge(8L, Integer.MAX_VALUE, true, false, false);
            currentCharge = currentElectric.getCharge();
            if (persistentData.m_128441_(EXTENDO_MARKER) && currentCharge < 8L) {
                player.m_21204_().m_22161_(rangeModifier.get());
                persistentData.m_128473_(EXTENDO_MARKER);
            }
        }
        if (holdingExtendo != wasHoldingExtendo) {
            if (!holdingExtendo || currentCharge < 8L) {
                player.m_21204_().m_22161_(rangeModifier.get());
                persistentData.m_128473_(EXTENDO_MARKER);
            } else {
                player.m_21204_().m_22178_(rangeModifier.get());
                persistentData.m_128379_(EXTENDO_MARKER, true);
            }
        }
        if (holdingDualExtendo != wasHoldingDualExtendo) {
            if (!holdingDualExtendo) {
                player.m_21204_().m_22161_(doubleRangeModifier.get());
                persistentData.m_128473_(DUAL_EXTENDO_MARKER);
            } else {
                player.m_21204_().m_22178_(doubleRangeModifier.get());
                persistentData.m_128379_(DUAL_EXTENDO_MARKER, true);
            }
        }
    }

    @SubscribeEvent
    public static void addReachToJoiningPlayersHoldingExtendo(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        CompoundTag persistentData = player.getPersistentData();
        if (persistentData.m_128441_(DUAL_EXTENDO_MARKER)) {
            player.m_21204_().m_22178_(doubleRangeModifier.get());
        } else if (persistentData.m_128441_(EXTENDO_MARKER)) {
            player.m_21204_().m_22178_(rangeModifier.get());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void dontMissEntitiesWhenYouHaveHighReachDistance(InputEvent.InteractionKeyMappingTriggered event) {
        AABB AABB2;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (mc.f_91073_ == null || player == null) {
            return;
        }
        if (!ElectricExtendoGrip.isHoldingExtendoGrip((Player)player)) {
            return;
        }
        if (mc.f_91077_ instanceof BlockHitResult && mc.f_91077_.m_6662_() != HitResult.Type.MISS) {
            return;
        }
        double d0 = player.m_21051_((Attribute)ForgeMod.BLOCK_REACH.get()).m_22135_();
        if (!player.m_7500_()) {
            d0 -= 0.5;
        }
        Vec3 Vector3d = player.m_20299_(AnimationTickHolder.getPartialTicks());
        Vec3 Vector3d1 = player.m_20252_(1.0f);
        Vec3 Vector3d2 = Vector3d.m_82520_(Vector3d1.f_82479_ * d0, Vector3d1.f_82480_ * d0, Vector3d1.f_82481_ * d0);
        EntityHitResult entityraytraceresult = ProjectileUtil.m_37287_((Entity)player, (Vec3)Vector3d, (Vec3)Vector3d2, (AABB)(AABB2 = player.m_20191_().m_82369_(Vector3d1.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0)), e -> !e.m_5833_() && e.m_6087_(), (double)(d0 * d0));
        if (entityraytraceresult != null) {
            Entity entity1 = entityraytraceresult.m_82443_();
            Vec3 Vector3d3 = entityraytraceresult.m_82450_();
            double d2 = Vector3d.m_82557_(Vector3d3);
            if (d2 < d0 * d0 || mc.f_91077_ == null || mc.f_91077_.m_6662_() == HitResult.Type.MISS) {
                mc.f_91077_ = entityraytraceresult;
                if (entity1 instanceof LivingEntity || entity1 instanceof ItemFrame) {
                    mc.f_91076_ = entity1;
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeDurabilityOnBlockBreak(BlockEvent.BreakEvent event) {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void consumeDurabilityOnPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return true;
    }

    @SubscribeEvent
    public static void bufferLivingAttackEvent(LivingAttackEvent event) {
        lastActiveDamageSource = event.getSource();
        DamageSource source = event.getSource();
        if (source == null) {
            return;
        }
        Entity trueSource = source.m_7639_();
    }

    @SubscribeEvent
    public static void attacksByExtendoGripHaveMoreKnockback(LivingKnockBackEvent event) {
        if (lastActiveDamageSource == null) {
            return;
        }
        Entity entity = lastActiveDamageSource.m_7640_();
        lastActiveDamageSource = null;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!ElectricExtendoGrip.isHoldingExtendoGrip(player)) {
            return;
        }
        event.setStrength(event.getStrength() + 2.0f);
    }

    private static boolean isUncaughtClientInteraction(Entity entity, Entity target) {
        if (entity.m_20280_(target) < 36.0) {
            return false;
        }
        if (!entity.m_9236_().f_46443_) {
            return false;
        }
        return entity instanceof Player;
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void notifyServerOfLongRangeAttacks(AttackEntityEvent event) {
        Entity target;
        Player entity = event.getEntity();
        if (!ElectricExtendoGrip.isUncaughtClientInteraction((Entity)entity, target = event.getTarget())) {
            return;
        }
        Player player = entity;
        if (ElectricExtendoGrip.isHoldingExtendoGrip(player)) {
            AllPackets.getChannel().sendToServer((Object)new ExtendoGripInteractionPacket(target));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void notifyServerOfLongRangeInteractions(PlayerInteractEvent.EntityInteract event) {
        Entity target;
        Player entity = event.getEntity();
        if (!ElectricExtendoGrip.isUncaughtClientInteraction((Entity)entity, target = event.getTarget())) {
            return;
        }
        Player player = entity;
        if (ElectricExtendoGrip.isHoldingExtendoGrip(player)) {
            AllPackets.getChannel().sendToServer((Object)new ExtendoGripInteractionPacket(target, event.getHand()));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void notifyServerOfLongRangeSpecificInteractions(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity target;
        Player entity = event.getEntity();
        if (!ElectricExtendoGrip.isUncaughtClientInteraction((Entity)entity, target = event.getTarget())) {
            return;
        }
        Player player = entity;
        if (ElectricExtendoGrip.isHoldingExtendoGrip(player)) {
            AllPackets.getChannel().sendToServer((Object)new ExtendoGripInteractionPacket(target, event.getHand(), event.getLocalPos()));
        }
    }

    public static boolean isHoldingExtendoGrip(Player player) {
        boolean inOff = player.m_21206_().m_150930_((Item)TFGItems.ELECTRIC_EXTENDO_GRIP.get());
        boolean inMain = player.m_21205_().m_150930_((Item)TFGItems.ELECTRIC_EXTENDO_GRIP.get());
        boolean holdingGrip = inOff || inMain;
        return holdingGrip;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new ExtendoGripItemRenderer()));
    }
}

