/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.tfgt.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.QuantumTankMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderHelper;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.machines.GTMachineUtils;
import com.gregtechceu.gtceu.common.data.models.GTMachineModels;
import com.gregtechceu.gtceu.common.data.models.GTModels;
import com.gregtechceu.gtceu.common.machine.multiblock.part.EnergyHatchPartMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumTankMachine;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.common.data.tfgt.TFGRecipeTypes;
import su.terrafirmagreg.core.common.data.tfgt.machine.electric.AqueousAccumulatorMachine;
import su.terrafirmagreg.core.common.data.tfgt.machine.electric.FoodRefrigeratorMachine;
import su.terrafirmagreg.core.common.data.tfgt.machine.electric.GasPressurizerMachine;
import su.terrafirmagreg.core.common.data.tfgt.machine.electric.InterplanetaryLogisticsMonitorMachine;
import su.terrafirmagreg.core.common.data.tfgt.machine.electric.SimpleFoodProcessingMachine;
import su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.part.RailgunAmmoLoaderMachine;
import su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.part.RailgunItemBusMachine;
import su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.part.SingleItemstackBus;

public class TFGMachines {
    public static final MachineDefinition BISMUTH_BRONZE_CRATE = GTMachineUtils.registerCrate((Material)GTMaterials.BismuthBronze, (int)54, (String)"Bismuth Bronze Crate");
    public static final MachineDefinition BLACK_BRONZE_CRATE = GTMachineUtils.registerCrate((Material)GTMaterials.BlackBronze, (int)54, (String)"Black Bronze Crate");
    public static final MachineDefinition BISMUTH_BRONZE_DRUM = GTMachineUtils.registerDrum((Material)GTMaterials.BismuthBronze, (int)32000, (String)"Bismuth Bronze Drum");
    public static final MachineDefinition BLACK_BRONZE_DRUM = GTMachineUtils.registerDrum((Material)GTMaterials.BlackBronze, (int)32000, (String)"Black Bronze Drum");
    public static final MachineDefinition[] FOOD_PROCESSOR = TFGMachines.registerTieredMachines(TFGCore.REGISTRATE, "food_processor", (x$0, x$1) -> new SimpleFoodProcessingMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.langValue("%s Food Processor %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).rotationState(RotationState.NON_Y_AXIS).recipeType(TFGRecipeTypes.FOOD_PROCESSOR_RECIPES).recipeModifiers(new RecipeModifier[]{GTRecipeModifiers.OC_NON_PERFECT}).editableUI((EditableMachineUI)SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)"food_processor"), TFGRecipeTypes.FOOD_PROCESSOR_RECIPES)).workableTieredHullModel(GTCEu.id((String)"block/machines/food_processor")).tooltips(GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] * 64L), (GTRecipeType)TFGRecipeTypes.FOOD_PROCESSOR_RECIPES, (long)((Integer)GTMachineUtils.defaultTankSizeFunction.apply(tier)).intValue(), (boolean)true)).register(), GTMachineUtils.ELECTRIC_TIERS);
    public static final MachineDefinition[] FOOD_OVEN = TFGMachines.registerTieredMachines(TFGCore.REGISTRATE, "food_oven", (x$0, x$1) -> new SimpleFoodProcessingMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.langValue("%s Electric Oven %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).rotationState(RotationState.NON_Y_AXIS).recipeType(TFGRecipeTypes.FOOD_OVEN_RECIPES).recipeModifier(GTRecipeModifiers.OC_NON_PERFECT).workableTieredHullModel(GTCEu.id((String)"block/machines/food_oven")).editableUI((EditableMachineUI)SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)"food_oven"), TFGRecipeTypes.FOOD_OVEN_RECIPES)).tooltips(GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] * 64L), (GTRecipeType)TFGRecipeTypes.FOOD_PROCESSOR_RECIPES, (long)((Integer)GTMachineUtils.defaultTankSizeFunction.apply(tier)).intValue(), (boolean)true)).register(), GTMachineUtils.ELECTRIC_TIERS);
    public static final MachineDefinition[] FOOD_REFRIGERATOR = TFGMachines.registerTieredMachines(TFGCore.REGISTRATE, "food_refrigerator", (x$0, x$1) -> new FoodRefrigeratorMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.langValue("%s Refrigerator %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).rotationState(RotationState.NON_Y_AXIS).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.voltage_in", (Object[])new Object[]{FormattingUtil.formatNumbers((long)GTValues.V[tier]), GTValues.VNF[tier]}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers((long)(GTValues.V[tier] * 64L))}), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{FoodRefrigeratorMachine.INVENTORY_SIZE(tier)})}).tooltips(new Component[]{Component.m_237110_((String)"tfg.machine.food_refrigerator_power_usage", (Object[])new Object[]{FormattingUtil.formatNumbers((int)(GTValues.VA[1] * tier))})}).workableTieredHullModel(GTCEu.id((String)"block/machines/food_refrigerator")).register(), GTValues.tiersBetween((int)2, (int)5));
    public static final MachineDefinition[] AQUEOUS_ACCUMULATOR = TFGMachines.registerTieredMachines(TFGCore.REGISTRATE, "aqueous_accumulator", (x$0, x$1) -> new AqueousAccumulatorMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.langValue("%s Aqueous Accumulator %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).editableUI((EditableMachineUI)SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)"aqueous_accumulator"), TFGRecipeTypes.AQUEOUS_ACCUMULATOR_RECIPES)).rotationState(RotationState.NON_Y_AXIS).recipeType(TFGRecipeTypes.AQUEOUS_ACCUMULATOR_RECIPES).recipeModifier(GTRecipeModifiers.OC_NON_PERFECT).workableTieredHullModel(GTCEu.id((String)"block/machines/aqueous_accumulator")).tooltips(GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] * 64L), (GTRecipeType)TFGRecipeTypes.AQUEOUS_ACCUMULATOR_RECIPES, (long)((Integer)GTMachineUtils.defaultTankSizeFunction.apply(tier)).intValue(), (boolean)true)).tooltips(new Component[]{GTMachineUtils.explosion()}).register(), GTMachineUtils.ELECTRIC_TIERS);
    public static final MachineDefinition[] GAS_PRESSURIZER = TFGMachines.registerTieredMachines(TFGCore.REGISTRATE, "gas_pressurizer", (x$0, x$1) -> new GasPressurizerMachine((IMachineBlockEntity)x$0, (int)x$1, new Object[0]), (tier, builder) -> builder.langValue("%s Gas Pressurizer %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).rotationState(RotationState.NON_Y_AXIS).recipeType(TFGRecipeTypes.GAS_PRESSURIZER_RECIPES).recipeModifier(GTRecipeModifiers.OC_NON_PERFECT).editableUI((EditableMachineUI)SimpleTieredMachine.EDITABLE_UI_CREATOR.apply(GTCEu.id((String)"gas_pressurizer"), TFGRecipeTypes.GAS_PRESSURIZER_RECIPES)).workableTieredHullModel(GTCEu.id((String)"block/machines/gas_pressurizer")).tooltips(GTMachineUtils.workableTiered((int)tier, (long)GTValues.V[tier], (long)(GTValues.V[tier] * 64L), (GTRecipeType)TFGRecipeTypes.GAS_PRESSURIZER_RECIPES, (long)((Integer)GTMachineUtils.defaultTankSizeFunction.apply(tier)).intValue(), (boolean)true)).register(), GTMachineUtils.ELECTRIC_TIERS);
    public static final MachineDefinition[] RAILGUN_ITEM_LOADER_IN = TFGMachines.registerTieredMachines(TFGCore.REGISTRATE, "railgun_item_loader_in", (holder, tier) -> new RailgunItemBusMachine((IMachineBlockEntity)holder, (int)tier, IO.IN), (tier, builder) -> builder.langValue("%s Interplanetary Railgun Loader %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).rotationState(RotationState.ALL).colorOverlayTieredHullModel(GTCEu.id((String)"block/overlay/machine/overlay_pipe_in_emissive"), null, GTCEu.id((String)"block/overlay/machine/overlay_item_hatch")).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.item_bus.import.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(1 + Math.min(9, tier)) * (1 + Math.min(9, tier))})}).allowCoverOnFront(true).register(), GTMachineUtils.ALL_TIERS);
    public static final MachineDefinition[] RAILGUN_ITEM_LOADER_OUT = TFGMachines.registerTieredMachines(TFGCore.REGISTRATE, "railgun_item_loader_out", (holder, tier) -> new RailgunItemBusMachine((IMachineBlockEntity)holder, (int)tier, IO.OUT), (tier, builder) -> builder.langValue("%s Interplanetary Railgun Unloader %s".formatted(GTValues.VLVH[tier], GTValues.VLVT[tier])).rotationState(RotationState.ALL).colorOverlayTieredHullModel(GTCEu.id((String)"block/overlay/machine/overlay_pipe_out_emissive"), null, GTCEu.id((String)"block/overlay/machine/overlay_item_hatch")).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.item_bus.export.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_capacity", (Object[])new Object[]{(1 + Math.min(9, tier)) * (1 + Math.min(9, tier))})}).allowCoverOnFront(true).register(), GTMachineUtils.ALL_TIERS);
    public static final MachineDefinition SINGLE_ITEMSTACK_BUS = TFGCore.REGISTRATE.machine("single_itemstack_bus", SingleItemstackBus::new).rotationState(RotationState.ALL).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.item_bus.import.tooltip"), Component.m_237115_((String)"tfg.tooltip.single_itemstack_bus.0"), Component.m_237115_((String)"tfg.tooltip.single_itemstack_bus.1")}).register();
    public static final MachineDefinition RAILGUN_AMMO_LOADER = TFGCore.REGISTRATE.machine("railgun_ammo_loader", RailgunAmmoLoaderMachine::new).register();
    public static final MachineDefinition INTERPLANETARY_LOGISTICS_MONITOR = TFGCore.REGISTRATE.machine("interplanetary_logistics_monitor", InterplanetaryLogisticsMonitorMachine::new).rotationState(RotationState.NON_Y_AXIS).register();
    public static final MachineDefinition ULV_SUPER_CHEST = GTRegistration.REGISTRATE.machine("ulv_super_chest", holder -> new QuantumChestMachine(holder, 0, 10000L, new Object[0])).langValue("ULV Super Chest").blockProp(BlockBehaviour.Properties::m_60988_).rotationState(RotationState.ALL).allowExtendedFacing(true).model(GTMachineModels.createTieredHullMachineModel((ResourceLocation)GTCEu.id((String)"block/machine/template/quantum/quantum_chest")).andThen(b -> b.addDynamicRenderer(DynamicRenderHelper::createQuantumChestRender))).hasBER(true).tooltipBuilder(GTMachineUtils.CHEST_TOOLTIPS).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.quantum_chest.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.item_storage_total", (Object[])new Object[]{FormattingUtil.formatNumbers((int)10000)})}).tier(0).register();
    public static final MachineDefinition ULV_SUPER_TANK = TFGMachines.createULVTank();
    public static final BlockEntry<Block> HERMETIC_CASING_ULV = ((BlockBuilder)GTRegistration.REGISTRATE.block("ulv_hermetic_casing", Block::new).lang("Basic Hermetic Casing").initialProperties(() -> Blocks.f_50075_).properties(p -> p.m_60922_((state, level, pos, end) -> false)).addLayer(() -> RenderType::m_110457_).blockstate(GTModels.createHermeticCasingModel((String)"ulv")).tag(new TagKey[]{CustomTags.MINEABLE_WITH_CONFIG_VALID_PICKAXE_WRENCH}).item(BlockItem::new).build()).register();
    public static final MachineDefinition HV_ENERGY_OUTPUT_HATCH_4A = GTRegistration.REGISTRATE.machine("hv_energy_output_hatch_4a", holder -> new EnergyHatchPartMachine(holder, 3, IO.OUT, 4, new Object[0])).langValue(GTValues.VNF[3] + " 4A Dynamo Hatch").rotationState(RotationState.ALL).abilities(new PartAbility[]{PartAbility.OUTPUT_ENERGY}).modelProperty((Property)GTMachineModelProperties.IS_FORMED, (Comparable)Boolean.valueOf(false)).tooltips(new Component[]{Component.m_237110_((String)"gtceu.universal.tooltip.voltage_out", (Object[])new Object[]{FormattingUtil.formatNumbers((long)GTValues.V[3]), GTValues.VNF[3]}), Component.m_237110_((String)"gtceu.universal.tooltip.amperage_out", (Object[])new Object[]{4}), Component.m_237110_((String)"gtceu.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers((long)EnergyHatchPartMachine.getHatchEnergyCapacity((int)3, (int)4))}), Component.m_237115_((String)"gtceu.machine.energy_hatch.output_hi_amp.tooltip")}).overlayTieredHullModel("energy_output_hatch_4a").tier(3).register();

    public static void init() {
    }

    private static MachineDefinition createULVTank() {
        long maxAmount = 1000000L;
        MachineDefinition definition = GTRegistration.REGISTRATE.machine("ulv_super_tank", MachineDefinition::new, holder -> new QuantumTankMachine(holder, 0, maxAmount, new Object[0]), MetaMachineBlock::new, QuantumTankMachineItem::new, MetaMachineBlockEntity::new).langValue("ULV Super Tank").blockProp(BlockBehaviour.Properties::m_60988_).rotationState(RotationState.ALL).allowExtendedFacing(true).model(GTMachineModels.createTieredHullMachineModel((ResourceLocation)GTCEu.id((String)"block/machine/template/quantum/quantum_tank")).andThen(b -> b.addDynamicRenderer(DynamicRenderHelper::createQuantumTankRender))).hasBER(true).tooltipBuilder(GTMachineUtils.TANK_TOOLTIPS).tooltips(new Component[]{Component.m_237115_((String)"gtceu.machine.quantum_tank.tooltip"), Component.m_237110_((String)"gtceu.universal.tooltip.fluid_storage_capacity", (Object[])new Object[]{FormattingUtil.formatNumbers((long)maxAmount)})}).tier(0).register();
        QuantumTankMachine.TANK_CAPACITY.put((Object)definition, maxAmount);
        return definition;
    }

    public static MachineDefinition[] registerTieredMachines(GTRegistrate registrate, String name, BiFunction<IMachineBlockEntity, Integer, MetaMachine> factory, BiFunction<Integer, MachineBuilder<MachineDefinition>, MachineDefinition> builder, int ... tiers) {
        MachineDefinition[] definitions = new MachineDefinition[tiers.length];
        for (int i = 0; i < tiers.length; ++i) {
            int tier = tiers[i];
            MachineBuilder register = registrate.machine(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, tier)).tier(tier);
            definitions[i] = builder.apply(tier, (MachineBuilder<MachineDefinition>)register);
        }
        return definitions;
    }

    public static MachineDefinition registerSteamMachine(String name, BiFunction<IMachineBlockEntity, Boolean, MetaMachine> factory, BiFunction<Boolean, MachineBuilder<MachineDefinition>, MachineDefinition> builder) {
        return builder.apply(true, (MachineBuilder<MachineDefinition>)TFGCore.REGISTRATE.machine("hp_%s".formatted(name), holder -> (MetaMachine)factory.apply((IMachineBlockEntity)holder, true)).tier(1));
    }
}

