/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.capability.ITurbineMachine;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IRotorHolderMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NuclearLargeTurbineMachine
extends WorkableElectricMultiblockMachine
implements ITieredMachine,
ITurbineMachine {
    public static final int MIN_DURABILITY_TO_WARN = 10;
    private final long BASE_EU_OUTPUT;
    private final int tier;

    public NuclearLargeTurbineMachine(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
        this.BASE_EU_OUTPUT = 8192L;
    }

    @Nullable
    private IRotorHolderMachine getRotorHolder() {
        for (IMultiPart part : this.getParts()) {
            if (!(part instanceof IRotorHolderMachine)) continue;
            IRotorHolderMachine rotorHolder = (IRotorHolderMachine)part;
            return rotorHolder;
        }
        return null;
    }

    public long getOverclockVoltage() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            return this.BASE_EU_OUTPUT * (long)rotorHolder.getTotalPower() / 100L;
        }
        return 0L;
    }

    protected double productionBoost() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            int maxSpeed = rotorHolder.getMaxRotorHolderSpeed();
            int currentSpeed = rotorHolder.getRotorSpeed();
            if (currentSpeed >= maxSpeed) {
                return 1.0;
            }
            return Math.pow(1.0 * (double)currentSpeed / (double)maxSpeed, 2.0);
        }
        return 0.0;
    }

    public boolean hasRotor() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        return rotorHolder != null && rotorHolder.hasRotor();
    }

    public int getRotorSpeed() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            return rotorHolder.getRotorSpeed();
        }
        return 0;
    }

    public int getMaxRotorHolderSpeed() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            return rotorHolder.getMaxRotorHolderSpeed();
        }
        return 0;
    }

    public int getTotalEfficiency() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            return rotorHolder.getTotalEfficiency();
        }
        return -1;
    }

    public long getCurrentProduction() {
        return this.isActive() && this.recipeLogic.getLastRecipe() != null ? this.recipeLogic.getLastRecipe().getOutputEUt().voltage() : 0L;
    }

    public int getRotorDurabilityPercent() {
        IRotorHolderMachine rotorHolder = this.getRotorHolder();
        if (rotorHolder != null && rotorHolder.hasRotor()) {
            return rotorHolder.getRotorDurabilityPercent();
        }
        return -1;
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof NuclearLargeTurbineMachine)) {
            return RecipeModifier.nullWrongType(NuclearLargeTurbineMachine.class, (MetaMachine)machine);
        }
        NuclearLargeTurbineMachine turbineMachine = (NuclearLargeTurbineMachine)machine;
        IRotorHolderMachine rotorHolder = turbineMachine.getRotorHolder();
        if (rotorHolder == null) {
            return ModifierFunction.NULL;
        }
        EnergyStack EUt = recipe.getOutputEUt();
        long turbineMaxVoltage = turbineMachine.getOverclockVoltage();
        double holderEfficiency = (double)rotorHolder.getTotalEfficiency() / 100.0;
        if (EUt.isEmpty() || turbineMaxVoltage <= EUt.voltage() || holderEfficiency <= 0.0) {
            return ModifierFunction.NULL;
        }
        int maxParallel = (int)(turbineMaxVoltage / EUt.getTotalEU());
        int actualParallel = ParallelLogic.getParallelAmountFast((MetaMachine)turbineMachine, (GTRecipe)recipe, (int)maxParallel);
        double eutMultiplier = turbineMachine.productionBoost() * (double)actualParallel;
        return ModifierFunction.builder().inputModifier(ContentModifier.multiplier((double)actualParallel)).outputModifier(ContentModifier.multiplier((double)actualParallel)).eutMultiplier(eutMultiplier).parallels(actualParallel).durationMultiplier(holderEfficiency).build();
    }

    public boolean regressWhenWaiting() {
        return false;
    }

    public boolean canVoidRecipeOutputs(RecipeCapability<?> capability) {
        return true;
    }

    public void addDisplayText(List<Component> textList) {
        IRotorHolderMachine rotorHolder;
        super.addDisplayText(textList);
        if (this.isFormed() && (rotorHolder = this.getRotorHolder()) != null && rotorHolder.getRotorEfficiency() > 0) {
            int rotorDurability;
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_speed", (Object[])new Object[]{FormattingUtil.formatNumbers((int)rotorHolder.getRotorSpeed()), FormattingUtil.formatNumbers((int)rotorHolder.getMaxRotorHolderSpeed())}));
            textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.efficiency", (Object[])new Object[]{rotorHolder.getTotalEfficiency()}));
            long maxProduction = this.getOverclockVoltage();
            long currentProduction = this.getCurrentProduction();
            if (this.isActive()) {
                textList.add(3, (Component)Component.m_237110_((String)"gtceu.multiblock.turbine.energy_per_tick", (Object[])new Object[]{FormattingUtil.formatNumbers((long)currentProduction), FormattingUtil.formatNumbers((long)maxProduction)}));
            }
            if ((rotorDurability = rotorHolder.getRotorDurabilityPercent()) > 10) {
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_durability", (Object[])new Object[]{rotorDurability}));
            } else {
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.rotor_durability", (Object[])new Object[]{rotorDurability}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            }
        }
    }

    @Generated
    public int getTier() {
        return this.tier;
    }
}

