/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.emi;

import com.forsteri.createliquidfuel.util.Triplet;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.compat.emi.TFGEmiPlugin;

public class LiquidBlazeBurnerRecipe
implements EmiRecipe {
    private final Fluid FLUID;
    private final String ID;
    private final Float BURN_TIME;
    private final Integer TICK_CONSUME;
    private final Boolean SUPERHEAT;

    public LiquidBlazeBurnerRecipe(Map.Entry<Fluid, Pair<ResourceLocation, Triplet<Integer, Boolean, Integer>>> liquidFuel) {
        this.FLUID = liquidFuel.getKey();
        this.ID = ((ResourceLocation)liquidFuel.getValue().getFirst()).toString();
        int burn_tick = (Integer)((Triplet)liquidFuel.getValue().getSecond()).getFirst();
        this.BURN_TIME = Float.valueOf((float)burn_tick / 20.0f);
        this.TICK_CONSUME = (Integer)((Triplet)liquidFuel.getValue().getSecond()).getThird();
        this.SUPERHEAT = (Boolean)((Triplet)liquidFuel.getValue().getSecond()).getSecond();
    }

    public EmiRecipeCategory getCategory() {
        return TFGEmiPlugin.BLAZE_BURNER;
    }

    @Nullable
    public ResourceLocation getId() {
        return TFGCore.id(this.ID.replace(':', '_') + "_emi");
    }

    public int getDisplayWidth() {
        return 140;
    }

    public int getDisplayHeight() {
        int defaultHeight = 38;
        if (this.SUPERHEAT.booleanValue()) {
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            return defaultHeight + 9;
        }
        return defaultHeight;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        int offsetY = 5;
        offsetY = this.createFluidWidget(widgetHolder, offsetY);
        this.createBurnerStatsWidget(widgetHolder, offsetY);
    }

    private int createFluidWidget(WidgetHolder holder, int offsetY) {
        int offsetX = 2;
        SlotWidget widget = new SlotWidget((EmiIngredient)EmiStack.of((Fluid)this.FLUID, (long)this.TICK_CONSUME.intValue()), offsetX, offsetY);
        holder.add((Widget)widget);
        MutableComponent mutableComponent = Component.m_237113_((String)(this.TICK_CONSUME + "mB"));
        int n = widget.getBounds().right() + 2;
        int n2 = widget.getBounds().bottom();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        holder.addText((Component)mutableComponent, n, n2 - 9, 0xFFFFFF, true);
        return widget.getBounds().bottom() + 2;
    }

    private int createBurnerStatsWidget(WidgetHolder holder, int offsetY) {
        Font font = Minecraft.m_91087_().f_91062_;
        Objects.requireNonNull(font);
        int lineHeight = 9;
        holder.addText((Component)Component.m_237110_((String)"tfg.emi.liquid_bb_burn_time", (Object[])new Object[]{this.BURN_TIME}), 2, offsetY, 0xFFFFFF, true);
        offsetY += lineHeight;
        if (this.SUPERHEAT.booleanValue()) {
            holder.addText((Component)Component.m_237115_((String)"tfg.emi.liquid_bb_superheat"), 2, offsetY, 0xFFFFFF, true);
        }
        return offsetY;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiStack.of((Fluid)this.FLUID));
    }

    public List<EmiStack> getOutputs() {
        return List.of();
    }
}

