/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.mixins.client.ftb;

import dev.ftb.mods.ftbquests.client.gui.quests.QuestScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.patchouli.api.PatchouliAPI;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={QuestScreen.class}, remap=false)
public abstract class QuestScreenMixin {
    private static final String GUIDE_RL = "tfc:field_guide";

    @Inject(method={"handleClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void catchTfcFieldGuidePaths(String scheme, String path, CallbackInfoReturnable<Boolean> cir) {
        if (!scheme.equals("guide") || path.isBlank()) {
            return;
        }
        cir.setReturnValue((Object)true);
        String[] bookArgs = path.split(" ");
        try {
            if (bookArgs.length > 3) {
                throw new IllegalArgumentException("more than 3 arguments");
            }
            if (!bookArgs[0].equals(GUIDE_RL)) {
                throw new IllegalArgumentException("invalid field guide resource location");
            }
            if (bookArgs.length > 1 && ResourceLocation.m_135820_((String)bookArgs[1]) == null) {
                throw new IllegalArgumentException("invalid entry resource location");
            }
            if (bookArgs.length == 3 && !StringUtils.isNumeric((CharSequence)bookArgs[2])) {
                throw new IllegalArgumentException("invalid page number");
            }
            ResourceLocation bookAddress = ResourceLocation.m_135820_((String)GUIDE_RL);
            if (bookArgs.length == 1) {
                PatchouliAPI.get().openBookGUI(bookAddress);
            } else {
                ResourceLocation entryAddress = ResourceLocation.m_135820_((String)bookArgs[1]);
                int pageNumber = bookArgs.length != 3 ? 0 : Integer.parseInt(bookArgs[2]);
                PatchouliAPI.get().openBookEntry(bookAddress, entryAddress, pageNumber);
            }
        }
        catch (Exception e) {
            String failureMessage = "failed to open guide, invalid path:" + path + "\nreason: " + String.valueOf(e);
            this.chatMessage(failureMessage);
        }
    }

    @Unique
    private void chatMessage(String message) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_213846_((Component)Component.m_237113_((String)message));
        }
    }
}

