/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.mixins.client.tfc;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.mojang.blaze3d.MethodsReturnNonnullByDefault;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.client.model.DoubleIngotPileBlockModel;
import net.dries007.tfc.client.model.SimpleStaticBlockEntityModel;
import net.dries007.tfc.common.blockentities.IngotPileBlockEntity;
import net.dries007.tfc.common.blocks.devices.DoubleIngotPileBlock;
import net.dries007.tfc.util.Metal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.client.TFGClientEventHandler;
import su.terrafirmagreg.core.client.TFGClientHelpers;
import su.terrafirmagreg.core.common.TFGHelpers;
import su.terrafirmagreg.core.mixins.common.tfc.IIngotPileBlockEntityAccessor;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
@Mixin(value={DoubleIngotPileBlockModel.class}, remap=false)
public abstract class DoubleIngotPileBlockModelMixin
implements SimpleStaticBlockEntityModel<DoubleIngotPileBlockModel, IngotPileBlockEntity> {
    public TextureAtlasSprite render(IngotPileBlockEntity pile, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        int ingots = (Integer)pile.m_58900_().m_61143_((Property)DoubleIngotPileBlock.DOUBLE_COUNT);
        Function textureAtlas = Minecraft.m_91087_().m_91258_(RenderHelpers.BLOCKS_ATLAS);
        List<?> pileEntries = ((IIngotPileBlockEntityAccessor)pile).getEntries();
        TextureAtlasSprite sprite = null;
        for (int i = 0; i < ingots; ++i) {
            MaterialStack material;
            ItemStack stack = TFGHelpers.getStackFromIngotPileTileEntityByIndex(pileEntries, i);
            try {
                material = ChemicalHelper.getMaterialStack((ItemStack)stack);
            }
            catch (ArrayIndexOutOfBoundsException | ConcurrentModificationException ex) {
                TFGCore.LOGGER.error("Encountered exception when attempting to get material from item stack: {}: {}", (Object)stack, (Object)ex);
                return RenderHelpers.missingTexture();
            }
            int primaryColor = material.material().getMaterialARGB(0);
            int secondaryColor = material.material().getMaterialARGB(1);
            Metal metalAtPos = pile.getOrCacheMetal(i);
            boolean shouldUseTFCRender = metalAtPos.getId() != Metal.unknown().getId() || material.isEmpty();
            ResourceLocation metalResource = shouldUseTFCRender ? metalAtPos.getSoftTextureId() : TFGClientEventHandler.TFCMetalBlockTexturePattern;
            sprite = (TextureAtlasSprite)textureAtlas.apply(metalResource);
            int layer = (i + 6) / 6;
            boolean oddLayer = layer % 2 == 1;
            float x = (float)(i % 3) * 0.33f;
            float y = (float)(layer - 1) * 1.0f / 6.0f;
            float z = i % 6 >= 3 ? 0.5f : 0.0f;
            poseStack.m_85836_();
            if (oddLayer) {
                poseStack.m_252880_(0.5f, 0.0f, 0.5f);
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
            }
            poseStack.m_252880_(x, y, z);
            float scale = 0.03125f;
            float minX = 0.015625f;
            float minY = 0.0f;
            float minZ = 0.015625f;
            float maxX = 0.31298828f;
            float maxY = 0.15625f;
            float maxZ = 0.46923828f;
            if (shouldUseTFCRender) {
                RenderHelpers.renderTexturedTrapezoidalCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)sprite, (int)packedLight, (int)packedOverlay, (float)0.015625f, (float)0.31298828f, (float)0.015625f, (float)0.46923828f, (float)0.046875f, (float)0.28173828f, (float)0.046875f, (float)0.43798828f, (float)0.0f, (float)0.15625f, (float)10.0f, (float)5.0f, (float)15.0f, (boolean)oddLayer);
            } else {
                TFGClientHelpers.renderTexturedTrapezoidalCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, 0.015625f, 0.31298828f, 0.015625f, 0.46923828f, 0.046875f, 0.28173828f, 0.046875f, 0.43798828f, 0.0f, 0.15625f, 10.0f, 5.0f, 15.0f, oddLayer, primaryColor, secondaryColor);
            }
            poseStack.m_85849_();
        }
        if (sprite == null) {
            sprite = RenderHelpers.missingTexture();
        }
        return sprite;
    }
}

