/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.mixins.common.ad_astra;

import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.OvenBottomBlockEntity;
import com.eerussianguy.firmalife.common.blocks.OvenBottomBlock;
import earth.terrarium.adastra.common.systems.EnvironmentEffects;
import earth.terrarium.adastra.common.tags.ModBlockTags;
import java.util.Optional;
import net.dries007.tfc.common.blockentities.AbstractFirepitBlockEntity;
import net.dries007.tfc.common.blockentities.LampBlockEntity;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.TFCCandleBlock;
import net.dries007.tfc.common.blocks.TFCCandleCakeBlock;
import net.dries007.tfc.common.blocks.TFCTorchBlock;
import net.dries007.tfc.common.blocks.TFCWallTorchBlock;
import net.dries007.tfc.common.blocks.devices.CharcoalForgeBlock;
import net.dries007.tfc.common.blocks.devices.FirepitBlock;
import net.dries007.tfc.common.blocks.devices.JackOLanternBlock;
import net.dries007.tfc.common.blocks.devices.LampBlock;
import net.dries007.tfc.common.blocks.devices.PitKilnBlock;
import net.dries007.tfc.common.blocks.soil.FarmlandBlock;
import net.dries007.tfc.common.blocks.soil.IGrassBlock;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.LampFuel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.common.data.TFGTags;

@Mixin(value={EnvironmentEffects.class}, remap=false)
public abstract class EnvironmentEffectsMixin {
    @Shadow
    private static boolean hasOxygenOnAnySide(ServerLevel level, BlockPos pos) {
        TFGCore.LOGGER.warn("EnvironmentEffectsMixin - Failed to bind mixin");
        return false;
    }

    @Inject(method={"tickHot"}, at={@At(value="TAIL")}, remap=false)
    private static void tfg$tickHot(ServerLevel level, BlockPos pos, BlockState state, CallbackInfo ci) {
        EnvironmentEffectsMixin.tfg$tickBlockBugWorkaround(level, pos, state);
    }

    @Inject(method={"tickCold"}, at={@At(value="TAIL")}, remap=false)
    private static void tfg$tickCold(ServerLevel level, BlockPos pos, BlockState state, CallbackInfo ci) {
        EnvironmentEffectsMixin.tfg$tickBlockBugWorkaround(level, pos, state);
    }

    @Unique
    private static void tfg$tickBlockBugWorkaround(ServerLevel level, BlockPos pos, BlockState state) {
        if (state.m_204336_(TFGTags.Blocks.DoNotDestroyInSpace)) {
            return;
        }
        Block block = state.m_60734_();
        if (EnvironmentEffectsMixin.hasOxygenOnAnySide(level, pos)) {
            return;
        }
        if (state.m_204336_(ModBlockTags.DESTROYED_IN_SPACE)) {
            level.m_46961_(pos, true);
        }
        if (block instanceof TFCTorchBlock) {
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
            level.m_46597_(pos, ((Block)TFCBlocks.DEAD_TORCH.get()).m_49966_());
        } else if (block instanceof TFCWallTorchBlock) {
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
            level.m_46597_(pos, Helpers.copyProperty((BlockState)((Block)TFCBlocks.DEAD_WALL_TORCH.get()).m_49966_(), (BlockState)state, (Property)WallTorchBlock.f_58119_));
        } else if (block instanceof IGrassBlock) {
            IGrassBlock grassBlock = (IGrassBlock)block;
            level.m_46597_(pos, grassBlock.getDirt());
        } else if (block instanceof FarmlandBlock) {
            FarmlandBlock.turnToDirt((BlockState)state, (Level)level, (BlockPos)pos);
        } else if (block instanceof TFCCandleBlock) {
            if (((Boolean)state.m_61143_((Property)TFCCandleBlock.f_152791_)).booleanValue()) {
                Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)TFCCandleBlock.f_152791_, (Comparable)Boolean.valueOf(false)));
            }
        } else if (block instanceof FirepitBlock) {
            BlockEntity be;
            if (((Boolean)state.m_61143_((Property)FirepitBlock.LIT)).booleanValue() && (be = level.m_7702_(pos)) instanceof AbstractFirepitBlockEntity) {
                AbstractFirepitBlockEntity firepit = (AbstractFirepitBlockEntity)be;
                firepit.extinguish(state);
            }
        } else if (block instanceof TFCCandleCakeBlock) {
            if (((Boolean)state.m_61143_((Property)TFCCandleCakeBlock.f_151895_)).booleanValue()) {
                Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)TFCCandleCakeBlock.f_151895_, (Comparable)Boolean.valueOf(false)));
            }
        } else if (block instanceof PitKilnBlock) {
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
            level.m_46961_(pos, false);
        } else if (block instanceof OvenBottomBlock) {
            Optional be;
            if (((Boolean)state.m_61143_((Property)OvenBottomBlock.LIT)).booleanValue() && (be = level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_BOTTOM.get())).isPresent()) {
                ((OvenBottomBlockEntity)be.get()).extinguish(state);
            }
        } else if (block instanceof CharcoalForgeBlock) {
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
            level.m_46597_(pos, (BlockState)((Block)TFCBlocks.CHARCOAL_PILE.get()).m_49966_().m_61124_((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf(7)));
        } else if (block instanceof JackOLanternBlock) {
            JackOLanternBlock jackOLantern = (JackOLanternBlock)block;
            jackOLantern.extinguish((Level)level, pos, state);
        } else if (block instanceof LampBlock && ((Boolean)state.m_61143_((Property)LampBlock.LIT)).booleanValue()) {
            LampFuel fuel;
            Optional be = level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.LAMP.get());
            if (be.isPresent() && (fuel = ((LampBlockEntity)be.get()).getFuel()) != null && fuel.getBurnRate() < 0) {
                return;
            }
            Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)LampBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }
}

