/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.mixins.common.create;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import su.terrafirmagreg.core.compat.create.ChainGTMaterialInterface;

@Mixin(value={ChainConveyorBlockEntity.class}, remap=false)
public abstract class ChainConveyorBlockEntityMixin
extends KineticBlockEntity
implements TransformableBlockEntity,
ChainGTMaterialInterface {
    @Unique
    public Map<BlockPos, Material> tfg$connectionMaterialStats = new HashMap<BlockPos, Material>();
    @Shadow
    BlockPos chainDestroyedEffectToSend;

    public ChainConveyorBlockEntityMixin(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    @Override
    @Unique
    public void addConnectionMaterial(BlockPos connection, Material chainMat) {
        BlockPos localTarget = connection.m_121996_((Vec3i)this.f_58858_);
        this.tfg$connectionMaterialStats.put(localTarget, chainMat);
    }

    @Override
    @Unique
    public Material getConnectionMaterial(BlockPos connection) {
        return this.tfg$connectionMaterialStats.get(connection);
    }

    @Override
    @Unique
    public Item getConnectionChainItem(BlockPos connection) {
        Material chainMat = this.tfg$connectionMaterialStats.get(connection);
        return ChemicalHelper.get((TagPrefix)TagPrefix.get((String)"chain"), (Material)(chainMat != null ? chainMat : GTMaterials.Copper)).m_41720_();
    }

    @Inject(method={"removeConnectionTo(Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/chainConveyor/ChainConveyorBlockEntity;notifyUpdate()V")}, remap=false)
    private void tfg$removeConnectionTo(BlockPos target, CallbackInfoReturnable<Boolean> cir) {
        BlockPos localTarget = target.m_121996_((Vec3i)this.f_58858_);
        this.tfg$connectionMaterialStats.remove(localTarget);
    }

    @Inject(method={"write(Lnet/minecraft/nbt/CompoundTag;Z)V"}, at={@At(value="TAIL")}, remap=false)
    private void tfg$write(CompoundTag compound, boolean clientPacket, CallbackInfo ci) {
        compound.m_128365_("ChainMaterials", (Tag)NBTHelper.writeCompoundList(this.tfg$connectionMaterialStats.entrySet(), entry -> {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128365_("Target", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)entry.getKey())));
            compoundTag.m_128359_("Material", ((Material)entry.getValue()).getName());
            return compoundTag;
        }));
    }

    @Inject(method={"read(Lnet/minecraft/nbt/CompoundTag;Z)V"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/kinetics/chainConveyor/ChainConveyorBlockEntity;updateBoxWorldPositions()V")}, remap=false)
    private void tfg$read(CompoundTag compound, boolean clientPacket, CallbackInfo ci) {
        this.tfg$connectionMaterialStats.clear();
        NBTHelper.iterateCompoundList((ListTag)compound.m_128437_("ChainMaterials", 10), c -> this.tfg$connectionMaterialStats.put(NbtUtils.m_129239_((CompoundTag)c.m_128469_("Target")), GTMaterials.get((String)c.m_128461_("Material"))));
    }

    @Inject(method={"chainDestroyed(Lnet/minecraft/core/BlockPos;ZZ)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void tfg$chainDestroyed(BlockPos target, boolean spawnDrops, boolean sendEffect, CallbackInfo ci) {
        int chainCount = ChainConveyorBlockEntity.getChainCost((BlockPos)target);
        if (sendEffect) {
            this.chainDestroyedEffectToSend = target;
            this.sendData();
        }
        if (!spawnDrops) {
            ci.cancel();
            return;
        }
        Item chainItem = this.getConnectionChainItem(target);
        ChainConveyorBlockEntity be = (ChainConveyorBlockEntity)this;
        if (this.f_58857_ != null && !be.forPointsAlongChains(target, chainCount, vec -> this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, vec.f_82479_, vec.f_82480_, vec.f_82481_, new ItemStack((ItemLike)chainItem))))) {
            while (chainCount > 0) {
                Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)new ItemStack((ItemLike)chainItem, Math.min(chainCount, 64)));
                chainCount -= 64;
            }
        }
        ci.cancel();
    }
}

