/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.mixins.common.tfc;

import java.util.Locale;
import net.dries007.tfc.common.entities.ai.predator.PackPredator;
import net.dries007.tfc.common.entities.ai.prey.TFCOcelot;
import net.dries007.tfc.common.entities.aquatic.TFCSquid;
import net.dries007.tfc.common.entities.livestock.MammalProperties;
import net.dries007.tfc.common.entities.livestock.TFCAnimal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.common.entities.livestock.horse.TFCChestedHorse;
import net.dries007.tfc.common.entities.livestock.horse.TFCHorse;
import net.dries007.tfc.common.entities.misc.TFCFishingHook;
import net.dries007.tfc.common.entities.predator.Predator;
import net.dries007.tfc.common.entities.prey.TFCFrog;
import net.dries007.tfc.common.entities.prey.TFCRabbit;
import net.dries007.tfc.common.entities.prey.WildAnimal;
import net.dries007.tfc.compat.jade.common.EntityTooltip;
import net.dries007.tfc.compat.jade.common.EntityTooltips;
import net.dries007.tfc.compat.jade.common.RegisterCallback;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.calendar.ICalendar;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.LevelReader;
import net.wanmine.wab.entity.Soarer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import su.terrafirmagreg.core.common.data.entities.glacianram.TFCGlacianRam;
import su.terrafirmagreg.core.common.data.entities.moonrabbit.MoonRabbit;
import su.terrafirmagreg.core.common.data.entities.sniffer.TFCSniffer;
import su.terrafirmagreg.core.common.data.entities.soarer.SoarerData;
import su.terrafirmagreg.core.common.data.entities.surfer.TFCSurfer;
import su.terrafirmagreg.core.common.data.entities.wraptor.TFCWraptor;

@Mixin(value={EntityTooltips.class}, remap=false)
public abstract class EntityTooltipsMixin {
    @Unique
    private static final EntityTooltip TFG_RABBIT = (level, entity, tooltip) -> {
        if (entity instanceof MoonRabbit) {
            MoonRabbit moonRabbit = (MoonRabbit)entity;
            tooltip.accept(Component.m_237115_((String)("tfg.tooltip.moon_rabbit_variant." + moonRabbit.getMoonVariant().name()).toLowerCase(Locale.ROOT)));
        } else if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            tooltip.accept(Helpers.translateEnum((Enum)rabbit.m_28554_(), (String)"rabbit_variant"));
        }
    };
    @Unique
    private static final EntityTooltip TFG_SURFER = (level, entity, tooltip) -> {
        if (entity instanceof TFCSurfer) {
            TFCSurfer surfer = (TFCSurfer)entity;
            tooltip.accept(Component.m_237115_((String)("tfg.tooltip.surfer_variant." + surfer.getCoralColor()).toLowerCase(Locale.ROOT)));
            tooltip.accept(Helpers.translateEnum((Enum)(surfer.isMale() ? TFCAnimalProperties.Gender.MALE : TFCAnimalProperties.Gender.FEMALE)));
            float familiarity = Math.max(0.0f, Math.min(1.0f, surfer.getFamiliarity()));
            String familiarityPercent = String.format("%.2f", Float.valueOf(familiarity * 100.0f));
            tooltip.accept(Component.m_237110_((String)"tfc.jade.familiarity", (Object[])new Object[]{familiarityPercent}));
            tooltip.accept(Component.m_237115_((String)"tfg.tooltip.attribution.surfer"));
        }
    };
    @Unique
    private static final EntityTooltip TFG_SOARER = (level, entity, tooltip) -> {
        if (entity instanceof Soarer) {
            Soarer soarer = (Soarer)entity;
            tooltip.accept(Helpers.translateEnum((Enum)(SoarerData.isMale(soarer) ? TFCAnimalProperties.Gender.MALE : TFCAnimalProperties.Gender.FEMALE)));
            float familiarity = Math.max(0.0f, Math.min(1.0f, SoarerData.getFamiliarity(soarer)));
            String familiarityPercent = String.format("%.2f", Float.valueOf(familiarity * 100.0f));
            tooltip.accept(Component.m_237110_((String)"tfc.jade.familiarity", (Object[])new Object[]{familiarityPercent}));
        }
    };
    @Unique
    private static final EntityTooltip TFG_ANIMAL = (level, entity, tooltip) -> {
        MammalProperties mammal;
        WildAnimal animal;
        if (entity instanceof WildAnimal) {
            animal = (WildAnimal)entity;
            if (animal.displayMaleCharacteristics()) {
                tooltip.accept(Helpers.translateEnum((Enum)TFCAnimalProperties.Gender.MALE));
            } else if (animal.displayFemaleCharacteristics()) {
                tooltip.accept(Helpers.translateEnum((Enum)TFCAnimalProperties.Gender.FEMALE));
            }
            if (animal.m_6162_()) {
                tooltip.accept(Component.m_237115_((String)"tfc.jade.juvenile"));
            }
        }
        if (entity instanceof TFCAnimalProperties) {
            TFCWraptor wraptor;
            TFCSniffer sniffer;
            animal = (TFCAnimalProperties)entity;
            MutableComponent line1 = Helpers.translateEnum((Enum)animal.getGender());
            if (animal.isFertilized()) {
                line1.m_130946_(", ").m_7220_((Component)Component.m_237115_((String)"tfc.tooltip.fertilized"));
            }
            float familiarity = Math.max(0.0f, Math.min(1.0f, animal.getFamiliarity()));
            String familiarityPercent = String.format("%.2f", Float.valueOf(familiarity * 100.0f));
            TFCAnimalProperties.Age age = animal.getAgeType();
            ChatFormatting familiarityStyle = ChatFormatting.GRAY;
            if (familiarity >= animal.getAdultFamiliarityCap() && age != TFCAnimalProperties.Age.CHILD) {
                familiarityStyle = ChatFormatting.RED;
            } else if ((double)familiarity >= (Double)TFCConfig.SERVER.familiarityDecayLimit.get()) {
                familiarityStyle = ChatFormatting.WHITE;
            }
            line1.m_130946_(", ").m_7220_((Component)Component.m_237110_((String)"tfc.jade.familiarity", (Object[])new Object[]{familiarityPercent}).m_130940_(familiarityStyle));
            tooltip.accept(line1);
            tooltip.accept(Component.m_237110_((String)"tfc.jade.animal_size", (Object[])new Object[]{animal.getGeneticSize()}));
            if (animal.isReadyForAnimalProduct()) {
                tooltip.accept(animal.getProductReadyName().m_130940_(ChatFormatting.GREEN));
            }
            if (animal instanceof TFCSniffer && (sniffer = (TFCSniffer)animal).isReadyForWoolProduct()) {
                tooltip.accept(sniffer.getWoolReadyName().m_130940_(ChatFormatting.GREEN));
            }
            if (animal instanceof TFCWraptor && (wraptor = (TFCWraptor)animal).isReadyForWoolProduct()) {
                tooltip.accept(wraptor.getWoolReadyName().m_130940_(ChatFormatting.GREEN));
            }
            if (animal.isReadyToMate()) {
                tooltip.accept(Component.m_237115_((String)"tfc.jade.can_mate"));
            }
            double usageRatio = animal.getUses() >= animal.getUsesToElderly() ? 0.99 : (double)((float)animal.getUses() / (float)animal.getUsesToElderly());
            switch (age) {
                case CHILD: {
                    tooltip.accept(Component.m_237110_((String)"tfc.jade.adulthood_progress", (Object[])new Object[]{Calendars.get((LevelReader)level).getTimeDelta(24000L * ((long)animal.getDaysToAdulthood() + animal.getBirthDay() - Calendars.get((LevelReader)level).getTotalDays()))}));
                    break;
                }
                case ADULT: {
                    tooltip.accept(Component.m_237110_((String)"tfc.jade.animal_wear", (Object[])new Object[]{String.format("%d%%", Math.min(100L, Math.round(100.0 * usageRatio)))}));
                    break;
                }
                case OLD: {
                    tooltip.accept(Component.m_237115_((String)"tfc.jade.old_animal"));
                }
            }
        }
        if (entity instanceof MammalProperties && (mammal = (MammalProperties)entity).getPregnantTime() > 0L) {
            tooltip.accept(Component.m_237110_((String)"tfc.tooltip.animal.pregnant", (Object[])new Object[]{entity.m_7755_().getString()}));
            ICalendar calendar = Calendars.get((LevelReader)level);
            tooltip.accept(Component.m_237110_((String)"tfc.jade.gestation_time_left", (Object[])new Object[]{calendar.getTimeDelta(24000L * (mammal.getGestationDays() + mammal.getPregnantTime() - Calendars.get((LevelReader)level).getTotalDays()))}));
        }
        if (entity instanceof TFCGlacianRam) {
            tooltip.accept(Component.m_237115_((String)"tfg.tooltip.attribution.glacian_ram"));
        }
        if (entity instanceof TFCSniffer) {
            tooltip.accept(Component.m_237115_((String)"tfg.tooltip.attribution.sniffer"));
        }
        if (entity instanceof TFCWraptor) {
            tooltip.accept(Component.m_237115_((String)"tfg.tooltip.attribution.wraptor"));
        }
    };

    @Overwrite
    public static void register(RegisterCallback<EntityTooltip, Entity> registry) {
        registry.register("animal", (Object)TFG_ANIMAL, TFCAnimal.class);
        registry.register("horse", (Object)EntityTooltips.ANIMAL, TFCHorse.class);
        registry.register("chested_horse", (Object)EntityTooltips.ANIMAL, TFCChestedHorse.class);
        registry.register("rabbit", (Object)EntityTooltips.ANIMAL, TFCRabbit.class);
        registry.register("wild_animal", (Object)EntityTooltips.ANIMAL, WildAnimal.class);
        registry.register("frog", (Object)EntityTooltips.FROG, TFCFrog.class);
        registry.register("squid", (Object)EntityTooltips.SQUID, TFCSquid.class);
        registry.register("fish", (Object)EntityTooltips.FISH, WaterAnimal.class);
        registry.register("predator", (Object)EntityTooltips.PREDATOR, Predator.class);
        registry.register("pack_predator", (Object)EntityTooltips.PACK_PREDATOR, PackPredator.class);
        registry.register("ocelot", (Object)EntityTooltips.OCELOT, TFCOcelot.class);
        registry.register("fishing_hook", (Object)EntityTooltips.HOOK, TFCFishingHook.class);
        registry.register("rabbit", (Object)TFG_RABBIT, Rabbit.class);
        registry.register("surfer", (Object)TFG_SURFER, TFCSurfer.class);
        registry.register("soarer", (Object)TFG_SOARER, Soarer.class);
    }
}

