/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.world.feature;

import com.mojang.serialization.Codec;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.material.FluidState;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.common.data.blocks.TallDecorativePlantBlock;
import su.terrafirmagreg.core.world.feature.TallDecorativePlantConfig;

public class TallDecorativePlantFeature
extends Feature<TallDecorativePlantConfig> {
    public TallDecorativePlantFeature(Codec<TallDecorativePlantConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<TallDecorativePlantConfig> context) {
        int i;
        WorldGenLevel level = context.m_159774_();
        BlockPos pos = context.m_159777_();
        if (!(((TallDecorativePlantConfig)context.m_159778_()).block() instanceof TallDecorativePlantBlock)) {
            TFGCore.LOGGER.error("TallDecorativePlantFeature was passed a block that isn't a TallDecorativePlantBlock! Was: {}", (Object)((TallDecorativePlantConfig)context.m_159778_()).block());
            return false;
        }
        int plantHeight = ((TallDecorativePlantConfig)context.m_159778_()).plantHeight();
        int middle = ((TallDecorativePlantConfig)context.m_159778_()).middle();
        BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
        int height = context.m_225041_().m_216332_(((TallDecorativePlantConfig)context.m_159778_()).minHeight(), ((TallDecorativePlantConfig)context.m_159778_()).maxHeight());
        for (int i2 = 0; i2 < height; ++i2) {
            cursor.m_122154_((Vec3i)pos, 0, i2, 0);
            if (EnvironmentHelpers.isWorldgenReplaceable((BlockState)level.m_8055_((BlockPos)cursor))) continue;
            return false;
        }
        int[] bsHeights = new int[height];
        int index = 0;
        if (middle != 0) {
            i = 0;
            while (i < middle) {
                bsHeights[index++] = i++;
            }
        }
        for (i = 0; i <= height - plantHeight; ++i) {
            bsHeights[index++] = middle;
        }
        if (middle < plantHeight - 1) {
            i = middle + 1;
            while (i < plantHeight) {
                bsHeights[index++] = i++;
            }
        }
        for (i = 0; i < Math.max(plantHeight, height); ++i) {
            cursor.m_122154_((Vec3i)pos, 0, i, 0);
            if (height < plantHeight && i == height) {
                level.m_7731_((BlockPos)cursor, Blocks.f_50016_.m_49966_(), 2);
                break;
            }
            BlockState state = ((TallDecorativePlantConfig)context.m_159778_()).block().m_49966_();
            FluidState currentFluid = level.m_6425_((BlockPos)cursor);
            if (!currentFluid.m_76178_()) {
                state = (BlockState)state.m_61124_((Property)TallDecorativePlantBlock.FLUID, (Comparable)TallDecorativePlantBlock.FLUID.keyForOrEmpty(currentFluid.m_76152_()));
            }
            this.m_5974_((LevelWriter)level, (BlockPos)cursor, (BlockState)state.m_61124_((Property)TallDecorativePlantBlock.HEIGHT, (Comparable)Integer.valueOf(bsHeights[i])));
        }
        return true;
    }
}

