/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.world.surface_rule;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.notenoughmail.kubejs_tfc.util.implementation.worldgen.RockSurfaceRuleSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.dries007.tfc.world.Codecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BadlandsSurfaceRuleSource
implements SurfaceRules.RuleSource {
    private final int rawRockWeight;
    private final List<BlockState> fullPalette;
    private final BlockState fallback;
    private final RockSurfaceRuleSource rockRuleSource;
    public static final KeyDispatchDataCodec<BadlandsSurfaceRuleSource> CODEC = KeyDispatchDataCodec.m_216236_((Codec)RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("raw_rock_weight").forGetter(BadlandsSurfaceRuleSource::rawRockWeight), (App)Codecs.BLOCK_STATE.listOf().fieldOf("palette").forGetter(BadlandsSurfaceRuleSource::palette), (App)Codecs.BLOCK_STATE.fieldOf("fallback").forGetter(BadlandsSurfaceRuleSource::fallback)).apply((Applicative)inst, BadlandsSurfaceRuleSource::new)));

    public BadlandsSurfaceRuleSource(int rawRockWeight, List<BlockState> palette, BlockState fallback) {
        this.rawRockWeight = rawRockWeight;
        this.fallback = fallback;
        this.rockRuleSource = new RockSurfaceRuleSource(RockSurfaceRuleSource.RockType.RAW, fallback, (x, y, z) -> fallback);
        this.fullPalette = new ArrayList<BlockState>();
        Random random = new Random(732489239423L);
        for (int j = 0; j < 512 / rawRockWeight + palette.size(); ++j) {
            ArrayList<BlockState> tempPalette = new ArrayList<BlockState>(palette);
            for (int i = 0; i < rawRockWeight; ++i) {
                tempPalette.add(null);
            }
            Collections.shuffle(tempPalette, random);
            this.fullPalette.addAll(tempPalette);
        }
    }

    @NotNull
    public KeyDispatchDataCodec<BadlandsSurfaceRuleSource> m_213795_() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        return new BadlandsRule(this.rawRockWeight, this.fullPalette, () -> this.rockRuleSource.apply(context));
    }

    public int rawRockWeight() {
        return this.rawRockWeight;
    }

    public List<BlockState> palette() {
        return this.fullPalette;
    }

    public BlockState fallback() {
        return this.fallback;
    }

    private record BadlandsRule(int rawRockWeight, List<BlockState> fullPalette, Supplier<SurfaceRules.SurfaceRule> rockRule) implements SurfaceRules.SurfaceRule
    {
        @Nullable
        public BlockState m_183550_(int x, int y, int z) {
            BlockState state = this.fullPalette.get((y + 64) % 512);
            if (state != null) {
                return state;
            }
            return this.rockRule.get().m_183550_(x, y, z);
        }
    }
}

