/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.dries007.tfc.client.RenderHelpers;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TFGClientHelpers {
    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, AABB bounds, int color1, int color2) {
        TFGClientHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, (float)bounds.f_82288_, (float)bounds.f_82289_, (float)bounds.f_82290_, (float)bounds.f_82291_, (float)bounds.f_82292_, (float)bounds.f_82293_, color1, color2);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, int color1, int color2) {
        TFGClientHelpers.renderTexturedCuboid(poseStack, buffer, sprite, packedLight, packedOverlay, minX, minY, minZ, maxX, maxY, maxZ, 16.0f * (maxX - minX), 16.0f * (maxY - minY), 16.0f * (maxZ - minZ), color1, color2);
    }

    public static void renderTexturedCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float xPixels, float yPixels, float zPixels, int color1, int color2) {
        TFGClientHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getXVertices((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ), zPixels, yPixels, 1.0f, 0.0f, 0.0f, color1, color2);
        TFGClientHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getYVertices((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ), zPixels, xPixels, 0.0f, 1.0f, 0.0f, color1, color2);
        TFGClientHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getZVertices((float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ), xPixels, yPixels, 0.0f, 0.0f, 1.0f, color1, color2);
    }

    public static void renderTexturedTrapezoidalCuboid(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float pMinX, float pMaxX, float pMinZ, float pMaxZ, float qMinX, float qMaxX, float qMinZ, float qMaxZ, float minY, float maxY, float xPixels, float yPixels, float zPixels, boolean invertNormal, int color1, int color2) {
        TFGClientHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getTrapezoidalCuboidXVertices((float)pMinX, (float)pMaxX, (float)pMinZ, (float)pMaxZ, (float)qMinX, (float)qMaxX, (float)qMinZ, (float)qMaxZ, (float)minY, (float)maxY), zPixels, yPixels, invertNormal ? 0.0f : 1.0f, 0.0f, invertNormal ? 1.0f : 0.0f, color1, color2);
        TFGClientHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getTrapezoidalCuboidYVertices((float)pMinX, (float)pMaxX, (float)pMinZ, (float)pMaxZ, (float)qMinX, (float)qMaxX, (float)qMinZ, (float)qMaxZ, (float)minY, (float)maxY), zPixels, xPixels, 0.0f, 1.0f, 0.0f, color1, color2);
        TFGClientHelpers.renderTexturedQuads(poseStack, buffer, sprite, packedLight, packedOverlay, RenderHelpers.getTrapezoidalCuboidZVertices((float)pMinX, (float)pMaxX, (float)pMinZ, (float)pMaxZ, (float)qMinX, (float)qMaxX, (float)qMinZ, (float)qMaxZ, (float)minY, (float)maxY), xPixels, yPixels, invertNormal ? 1.0f : 0.0f, 0.0f, invertNormal ? 0.0f : 1.0f, color1, color2);
    }

    public static void renderTexturedQuads(PoseStack poseStack, VertexConsumer buffer, TextureAtlasSprite sprite, int packedLight, int packedOverlay, float[][] vertices, float uSize, float vSize, float normalX, float normalY, float normalZ, int color1, int color2) {
        for (float[] v : vertices) {
            TFGClientHelpers.renderTexturedVertex(poseStack, buffer, packedLight, packedOverlay, v[0], v[1], v[2], sprite.m_118367_((double)(v[3] * uSize)), sprite.m_118393_((double)(v[4] * vSize)), v[5] * normalX, v[5] * normalY, v[5] * normalZ, color1, color2);
        }
    }

    public static void renderTexturedVertex(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, int color1, int color2) {
        int pColor = TFGClientHelpers.increaseBrightness(FastColor.ARGB32.m_13657_((int)color1, (int)color2), 90);
        int shadeToInt = (int)(RenderHelpers.getShade((float)normalX, (float)normalY, (float)normalZ) * 255.0f);
        int pColor2 = FastColor.ARGB32.m_13657_((int)pColor, (int)FastColor.ARGB32.m_13660_((int)255, (int)shadeToInt, (int)shadeToInt, (int)shadeToInt));
        buffer.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z).m_193479_(pColor2).m_7421_(u, v).m_85969_(packedLight).m_86008_(packedOverlay).m_252939_(poseStack.m_85850_().m_252943_(), normalX, normalY, normalZ).m_5752_();
    }

    public static int increaseBrightness(int argbValue, int increment) {
        int alpha = argbValue >> 24 & 0xFF;
        int red = argbValue >> 16 & 0xFF;
        int green = argbValue >> 8 & 0xFF;
        int blue = argbValue & 0xFF;
        red = Math.min(255, red + increment);
        green = Math.min(255, green + increment);
        blue = Math.min(255, blue + increment);
        return alpha << 24 | (0xFF000000 | red << 16 | green << 8 | blue);
    }

    public static Vec2 nextVec2InRadius(RandomSource random, float radius) {
        float y;
        float x;
        while (Mth.m_211589_((double)(x = random.m_188501_() * 2.0f - 1.0f), (double)(y = random.m_188501_() * 2.0f - 1.0f)) > 1.0) {
        }
        return new Vec2(x * radius, y * radius);
    }
}

