/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common;

import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.mixins.common.tfc.IIngotPileBlockEntityEntryAccessor;

public final class TFGHelpers {
    public static final Random RANDOM = new Random();
    public static boolean isMaterialRegistrationFinished;

    @Nullable
    public static Material getMaterial(@NotNull String materialName) {
        Material material = GTCEuAPI.materialManager.getMaterial(materialName);
        if (material == null) {
            material = GTCEuAPI.materialManager.getMaterial("tfg:" + materialName);
        }
        return material;
    }

    public static ItemStack getStackFromIngotPileTileEntityByIndex(List<?> entries, int index) {
        try {
            return ((IIngotPileBlockEntityEntryAccessor)entries.get(index)).getStack();
        }
        catch (IndexOutOfBoundsException e) {
            return ItemStack.f_41583_;
        }
    }

    public static void sendChatMessagePortalsIsDisabled(Level level, Entity entity) {
        if (level.m_5776_() && level.m_46467_() % 100L == 0L) {
            entity.m_213846_((Component)Component.m_237115_((String)"tfg.disabled_portal").m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }

    public static void registerMaterialInfo(ResourceLocation itemId, Map<String, Double> materialStacks) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
        if (item == null) {
            TFGCore.LOGGER.error("Error in registerMaterialInfo - item not found: {}", (Object)itemId);
            return;
        }
        Reference2LongOpenHashMap matStacks = new Reference2LongOpenHashMap();
        for (Map.Entry<String, Double> tuple : materialStacks.entrySet()) {
            Material material = TFGHelpers.getMaterial(tuple.getKey());
            if (material == null) {
                TFGCore.LOGGER.error("Error in registerMaterialInfo - material not found: {}", (Object)tuple.getKey());
                return;
            }
            matStacks.addTo((Object)material, Math.round(tuple.getValue() * 3628800.0));
        }
        ItemMaterialData.registerMaterialInfo((ItemLike)item, (ItemMaterialInfo)new ItemMaterialInfo((Reference2LongMap)matStacks));
    }
}

