/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data;

import appeng.api.upgrades.Upgrades;
import com.gregtechceu.gtceu.api.item.ComponentItem;
import de.mennomax.astikorcarts.item.CartItem;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import su.terrafirmagreg.core.common.data.TFGBlocks;
import su.terrafirmagreg.core.common.data.TFGEntities;
import su.terrafirmagreg.core.common.data.TFGFluids;
import su.terrafirmagreg.core.common.data.items.DirtyDnaSyringeItem;
import su.terrafirmagreg.core.common.data.items.ElectricExtendoGrip;
import su.terrafirmagreg.core.common.data.items.EmptyDnaSyringeItem;
import su.terrafirmagreg.core.common.data.items.FilledDnaSyringeItem;
import su.terrafirmagreg.core.common.data.items.PiglinDisguise;
import su.terrafirmagreg.core.common.data.items.ProgenitorCellsItem;
import su.terrafirmagreg.core.common.data.items.TrowelItem;

public class TFGItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tfg");
    public static final RegistryObject<Item> PIGLIN_DISGUISE = ITEMS.register("piglin_disguise", () -> new PiglinDisguise((Block)TFGBlocks.PIGLIN_DISGUISE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> TROWEL = ITEMS.register("trowel", () -> new TrowelItem(new Item.Properties()));
    public static final RegistryObject<Item> EMPTY_DNA_SYRINGE = ITEMS.register("empty_dna_syringe", () -> new EmptyDnaSyringeItem(new Item.Properties()));
    public static final RegistryObject<Item> DIRTY_DNA_SYRINGE = ITEMS.register("dirty_dna_syringe", () -> new DirtyDnaSyringeItem(new Item.Properties()));
    public static final RegistryObject<Item> FILLED_DNA_SYRINGE = ITEMS.register("filled_dna_syringe", () -> new FilledDnaSyringeItem(new Item.Properties()));
    public static final RegistryObject<Item> PROGENITOR_CELLS = ITEMS.register("progenitor_cells", () -> new ProgenitorCellsItem(new Item.Properties()));
    public static final RegistryObject<Item> MOON_RABBIT_EGG = TFGItems.registerSpawnEgg(TFGEntities.MOON_RABBIT, 15767516, 9756658);
    public static final RegistryObject<Item> GLACIAN_RAM_EGG = TFGItems.registerSpawnEgg(TFGEntities.GLACIAN_RAM, 0xFFEDFF, 3997758);
    public static final RegistryObject<Item> SNIFFER_SPAWN_EGG = TFGItems.registerSpawnEgg(TFGEntities.SNIFFER, 11285007, 4829025);
    public static final RegistryObject<Item> WRAPTOR_SPAWN_EGG = TFGItems.registerSpawnEgg(TFGEntities.WRAPTOR, 15767516, 4829025);
    public static final RegistryObject<Item> SURFER_SPAWN_EGG = TFGItems.registerSpawnEgg(TFGEntities.SURFER, 7644045, 12824430);
    public static final RegistryObject<BucketItem> MARS_WATER_BUCKET = TFGItems.register("semiheavy_ammoniacal_water_bucket", () -> new BucketItem((Fluid)TFGFluids.MARS_WATER.getSource(), new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1)));
    public static final RegistryObject<Item> RAILGUN_AMMO_SHELL = ITEMS.register("railgun_ammo_shell", () -> new Item(new Item.Properties().m_41487_(16)));
    public static final RegistryObject<Item> GLACIAN_WOOL = ITEMS.register("glacian_wool", () -> new Item(new Item.Properties().m_41487_(32)));
    public static final RegistryObject<Item> SNIFFER_WOOL = ITEMS.register("sniffer_wool", () -> new Item(new Item.Properties().m_41487_(32)));
    public static final RegistryObject<Item> SNIFFER_EGG = ITEMS.register("sniffer_egg", () -> new Item(new Item.Properties().m_41487_(32)));
    public static final RegistryObject<Item> WRAPTOR_WOOL = ITEMS.register("wraptor_wool", () -> new Item(new Item.Properties().m_41487_(32)));
    public static final RegistryObject<Item> WRAPTOR_EGG = ITEMS.register("wraptor_egg", () -> new Item(new Item.Properties().m_41487_(32)));
    public static final RegistryObject<ComponentItem> ELECTRIC_EXTENDO_GRIP = ITEMS.register("electric_extendo_grip", () -> new ElectricExtendoGrip(new Item.Properties()));
    public static final RegistryObject<Item> WIRELESS_CARD = ITEMS.register("wireless_card", () -> Upgrades.createUpgradeCardItem((Item.Properties)new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41487_(1)));
    public static final RegistryObject<Item> RNR_PLOW = ITEMS.register("rnr_plow", () -> new CartItem(new Item.Properties().m_41487_(1)));

    private static RegistryObject<Item> register(String name) {
        return TFGItems.register(name, () -> new Item(new Item.Properties()));
    }

    private static <T extends Item> RegistryObject<T> register(String name, Supplier<T> item) {
        return ITEMS.register(name.toLowerCase(Locale.ROOT), item);
    }

    private static <T extends EntityType<? extends Mob>> RegistryObject<Item> registerSpawnEgg(RegistryObject<T> entity, int color1, int color2) {
        return TFGItems.register("spawn_egg/" + entity.getId().m_135815_(), () -> new ForgeSpawnEggItem((Supplier)entity, color1, color2, new Item.Properties()));
    }
}

