/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.entities.glacianram;

import java.util.List;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.entities.livestock.ProducingMammal;
import net.dries007.tfc.common.entities.livestock.TFCAnimalProperties;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.config.animals.ProducingMammalConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.dries007.tfc.util.events.AnimalProductEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.common.data.TFGItems;
import su.terrafirmagreg.core.common.data.TFGTags;

public class TFCGlacianRam
extends ProducingMammal
implements IForgeShearable {
    static double familiarityCap = 0.35;
    static int adulthoodDays = 35;
    static int uses = 160;
    static boolean eatsRottenFood = false;
    static int produceTicks = 96000;
    static double produceFamiliarity = 0.15;
    static int childCount = 1;
    static long gestationDays = 30L;

    public TFCGlacianRam(EntityType<? extends ProducingMammal> type, Level level, TFCSounds.EntitySound sounds, ProducingMammalConfig config) {
        super(type, level, sounds, config);
    }

    public static TFCGlacianRam makeTFCGlacianRam(EntityType<? extends ProducingMammal> type, Level level) {
        return new TFCGlacianRam(type, level, TFCSounds.SHEEP, TFCConfig.SERVER.sheepConfig);
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    public static boolean spawnRules(EntityType<? extends TFCGlacianRam> type, LevelAccessor level, MobSpawnType spawn, BlockPos pos, RandomSource rand) {
        return level.m_8055_(pos).m_60795_();
    }

    public float getAdultFamiliarityCap() {
        return (float)familiarityCap;
    }

    public int getDaysToAdulthood() {
        return adulthoodDays;
    }

    public int getUsesToElderly() {
        return uses;
    }

    public boolean eatsRottenFood() {
        return eatsRottenFood;
    }

    public boolean isReadyForAnimalProduct() {
        return (double)this.getFamiliarity() > produceFamiliarity && this.hasProduct();
    }

    public long getProductsCooldown() {
        return Math.max(0L, (long)produceTicks + this.getProducedTick() - Calendars.get((LevelReader)this.m_9236_()).getTicks());
    }

    public int getChildCount() {
        return childCount;
    }

    public long getGestationDays() {
        return gestationDays;
    }

    public TagKey<Item> getFoodTag() {
        return TFGTags.Items.GlacianRamFood;
    }

    public boolean hasProduct() {
        return (this.getProducedTick() <= 0L || this.getProductsCooldown() <= 0L) && this.getAgeType() == TFCAnimalProperties.Age.ADULT;
    }

    public boolean isShearable(@NotNull ItemStack item, Level level, BlockPos pos) {
        return this.isReadyForAnimalProduct();
    }

    @NotNull
    public List<ItemStack> onSheared(@Nullable Player player, @NotNull ItemStack item, Level level, BlockPos pos, int fortune) {
        this.setProductsCooldown();
        this.m_5496_(SoundEvents.f_12344_, 1.0f, 1.0f);
        AnimalProductEvent event = new AnimalProductEvent(level, pos, player, (TFCAnimalProperties)this, this.getWoolItem(), item, 1);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            this.addUses(event.getUses());
        }
        return List.of(event.getProduct());
    }

    public ItemStack getWoolItem() {
        int amount = (int)Math.floor(3.0f * this.getFamiliarity() + 1.0f);
        return new ItemStack((ItemLike)TFGItems.GLACIAN_WOOL.get(), amount);
    }

    public boolean hasWool() {
        long cooldown = this.getProductsCooldown();
        return cooldown == 0L;
    }

    /*
     * Enabled aggressive block sorting
     */
    public AgeableMob m_142606_(ServerLevel level, AgeableMob other) {
        if (other != this && this.getGender() == TFCAnimalProperties.Gender.FEMALE && other instanceof TFCGlacianRam) {
            TFCGlacianRam otherFertile = (TFCGlacianRam)other;
            if (!this.isFertilized()) {
                this.onFertilized(otherFertile);
                return null;
            }
        }
        if (other != this) return null;
        Entity baby = this.getEntityTypeForBaby().m_20615_((Level)level);
        if (!(baby instanceof TFCAnimalProperties)) return null;
        TFCAnimalProperties properties = (TFCAnimalProperties)baby;
        if (!(baby instanceof AgeableMob)) return null;
        AgeableMob ageable = (AgeableMob)baby;
        this.setBabyTraits(properties);
        return ageable;
    }

    public void onFertilized(TFCGlacianRam male) {
        male.setFertilized(true);
        male.setLastFed(this.getLastFed() - 1L);
        this.setLastFed(this.getLastFed() - 1L);
        this.addUses(5);
        male.setPregnantTime(this.getCalendar().getTotalDays());
        CompoundTag genes = new CompoundTag();
        male.createGenes(genes, this);
        male.setGenes(genes.m_128456_() ? null : genes);
    }

    public void createGenes(CompoundTag tag, TFCGlacianRam mate) {
        tag.m_128405_("size", mate.getGeneticSize() + this.getGeneticSize());
        tag.m_128379_("runt", this.getEntity().m_217043_().m_188503_(20) == 0);
    }

    public MutableComponent getProductReadyName() {
        return Component.m_237115_((String)"tfc.jade.product.wool");
    }
}

