/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.entities.surfer;

import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.entities.BrainBreeder;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraftforge.common.ForgeMod;
import net.wanmine.wab.entity.Surfer;
import net.wanmine.wab.entity.Toxlacanth;
import net.wanmine.wab.init.data.WabTags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.common.data.TFGBlocks;
import su.terrafirmagreg.core.common.data.TFGEntities;

public class TFCSurfer
extends Surfer
implements BrainBreeder {
    public static final EntityDataAccessor<Boolean> DATA_IS_MALE = SynchedEntityData.m_135353_(TFCSurfer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Float> DATA_FAMILIARITY = SynchedEntityData.m_135353_(TFCSurfer.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private long lastMated = Long.MIN_VALUE;
    private long nextFeedTime = Long.MIN_VALUE;

    public TFCSurfer(EntityType<? extends AbstractHorse> animal, Level level) {
        super(animal, level);
    }

    public static TFCSurfer makeTFCSurfer(EntityType<? extends AbstractHorse> type, Level level) {
        return new TFCSurfer(type, level);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData groupData, CompoundTag tag) {
        float r = this.f_19796_.m_188501_();
        if ((double)r > 0.9) {
            this.setCoralColor("brain");
        } else if ((double)r > 0.8) {
            this.setCoralColor("bubble");
        } else if ((double)r > 0.7) {
            this.setCoralColor("tube");
        } else if ((double)r > 0.6) {
            this.setCoralColor("fire");
        } else if ((double)r > 0.5) {
            this.setCoralColor("horn");
        }
        this.setIsMale(this.f_19796_.m_188499_());
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    public static boolean spawnRules(EntityType<? extends TFCSurfer> type, LevelAccessor level, MobSpawnType spawn, BlockPos pos, RandomSource rand) {
        return level.m_8055_(pos) == ((LiquidBlock)TFGBlocks.MARS_WATER.get()).m_49966_();
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, Attributes.f_22279_.m_22082_()).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 0.3).m_22268_(Attributes.f_22288_, 0.6).m_22268_(Attributes.f_22279_, 0.1).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 8.0);
    }

    public void m_8119_() {
        this.m_20301_(300);
        super.m_8119_();
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Toxlacanth.class, false, false));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_MALE, (Object)true);
        this.f_19804_.m_135372_(DATA_FAMILIARITY, (Object)Float.valueOf(0.0f));
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFamiliarity(tag.m_128457_("familiarity"));
        this.setIsMale(tag.m_128471_("male"));
        this.lastMated = tag.m_128454_("lastMated");
        this.nextFeedTime = tag.m_128454_("nextFeed");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("male", this.isMale());
        tag.m_128350_("familiarity", this.getFamiliarity());
        tag.m_128356_("lastMated", this.lastMated);
        tag.m_128356_("nextFeed", this.nextFeedTime);
    }

    public float getFamiliarity() {
        return ((Float)this.f_19804_.m_135370_(DATA_FAMILIARITY)).floatValue();
    }

    public void setFamiliarity(float familiarity) {
        this.f_19804_.m_135381_(DATA_FAMILIARITY, (Object)Float.valueOf(familiarity));
    }

    public void setIsMale(boolean male) {
        this.f_19804_.m_135381_(DATA_IS_MALE, (Object)male);
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_MALE);
    }

    public void setMated(long ticks) {
        this.lastMated = ticks;
    }

    public boolean m_7848_(Animal animal) {
        if (animal != this && animal instanceof TFCSurfer) {
            TFCSurfer other = (TFCSurfer)animal;
            float min = 0.3f;
            return other.isMale() != this.isMale() && this.beenLongEnoughToMate() && other.beenLongEnoughToMate() && this.getFamiliarity() > 0.3f && other.getFamiliarity() > 0.3f && this.fedRecently() && other.fedRecently();
        }
        return false;
    }

    protected boolean beenLongEnoughToMate() {
        return Calendars.get((LevelReader)this.m_9236_()).getTicks() > this.lastMated + 288000L;
    }

    public boolean m_6898_(ItemStack stack) {
        return !FoodCapability.isRotten((ItemStack)stack) && Helpers.isItem((ItemStack)stack, (TagKey)WabTags.Items.SURFER_FOOD);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)TFGEntities.SURFER.get()).m_20615_((Level)level);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack held = player.m_21120_(hand);
        if (this.m_6898_(held)) {
            long ticks;
            if (!this.m_9236_().f_46443_ && (ticks = Calendars.SERVER.getTicks()) > this.nextFeedTime) {
                this.setFamiliarity(this.getFamiliarity() + 0.1f);
                this.nextFeedTime = ticks + 24000L;
                this.m_142075_(player, hand, held);
                this.m_216990_(SoundEvents.f_215692_);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private boolean fedRecently() {
        return Calendars.get((LevelReader)this.m_9236_()).getTicks() < this.nextFeedTime;
    }

    public boolean m_30614_() {
        return this.getFamiliarity() > 0.15f;
    }
}

