/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import su.terrafirmagreg.core.common.TFGHelpers;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SMRGenerator
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SMRGenerator.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    private final int tier;
    static List<GTRecipe> lubricantRecipes = new ArrayList<GTRecipe>();
    static List<GTRecipe> boostRecipes = new ArrayList<GTRecipe>();
    public static final String LUBRICATION_KEY = "lubrication";
    public static final String BOOST_KEY = "boost";
    public static final String DURATION_KEY = "duration";
    private Optional<GTRecipe> activeBoost = Optional.empty();
    private int runningTimer = 0;
    private int boostDuration = 0;
    private int lubeDuration = 0;

    public SMRGenerator(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
    }

    private boolean isIntakesObstructed() {
        Direction dir = this.getFrontFacing();
        boolean mutableXZ = dir.m_122434_() == Direction.Axis.Z;
        BlockPos centerPos = this.getPos().m_121945_(dir);
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                if (x == 0 && y == 0) continue;
                BlockPos blockPos = centerPos.m_7918_(mutableXZ ? x : 0, y, mutableXZ ? 0 : x);
                BlockState blockState = this.getLevel().m_8055_(blockPos);
                if (blockState.m_60795_()) continue;
                return true;
            }
        }
        return false;
    }

    public long getOverclockVoltage() {
        return GTValues.V[this.tier];
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof SMRGenerator)) {
            return RecipeModifier.nullWrongType(SMRGenerator.class, (MetaMachine)machine);
        }
        SMRGenerator engineMachine = (SMRGenerator)machine;
        long EUt = recipe.getOutputEUt().voltage();
        if (EUt * (long)recipe.duration < 1L) {
            return ModifierFunction.NULL;
        }
        Optional<GTRecipe> lubeRecipe = lubricantRecipes.stream().filter(lr -> RecipeHelper.matchRecipe((IRecipeCapabilityHolder)engineMachine, (GTRecipe)lr).isSuccess()).findFirst();
        if (EUt > 0L && !engineMachine.isIntakesObstructed() && lubeRecipe.isPresent()) {
            double eutMultiplier;
            int maxParallel = (int)(engineMachine.getOverclockVoltage() / EUt);
            int actualParallel = ParallelLogic.getParallelAmount((MetaMachine)engineMachine, (GTRecipe)recipe, (int)maxParallel);
            int tier = lubeRecipe.get().data.m_128451_(LUBRICATION_KEY);
            float durationModifier = (float)tier / 2.0f;
            int consumptionMult = 1;
            if (engineMachine.activeBoost.isPresent()) {
                consumptionMult = engineMachine.activeBoost.get().data.m_128451_(BOOST_KEY);
                eutMultiplier = actualParallel * (consumptionMult * 3);
            } else {
                eutMultiplier = actualParallel;
            }
            return ModifierFunction.builder().inputModifier(ContentModifier.multiplier((double)(consumptionMult * actualParallel))).outputModifier(ContentModifier.multiplier((double)(consumptionMult * actualParallel))).durationMultiplier((double)durationModifier).eutMultiplier(eutMultiplier).parallels(actualParallel).build();
        }
        return ModifierFunction.NULL;
    }

    public boolean onWorking() {
        int duration;
        long EUt;
        boolean value = super.onWorking();
        GTRecipe recipe = this.recipeLogic.getLastRecipe();
        if (recipe != null && (EUt = recipe.getOutputEUt().voltage()) / (long)recipe.parallels * (long)(duration = recipe.duration) < 1L) {
            this.getRecipeLogic().setWaiting((Component)Component.m_237115_((String)"cosmiccore.errors.bad_fuel"));
        }
        if (this.lubeDuration <= 0) {
            for (GTRecipe lubeRecipe : lubricantRecipes) {
                if (!RecipeHelper.matchRecipe((IRecipeCapabilityHolder)this, (GTRecipe)lubeRecipe).isSuccess() || !RecipeHelper.handleRecipeIO((IRecipeCapabilityHolder)this, (GTRecipe)lubeRecipe, (IO)IO.IN, (Map)this.getRecipeLogic().getChanceCaches()).isSuccess()) continue;
                this.lubeDuration = lubeRecipe.data.m_128451_(DURATION_KEY);
                break;
            }
            if (this.lubeDuration == 0) {
                this.recipeLogic.interruptRecipe();
                return false;
            }
        }
        if (this.boostDuration <= 0) {
            this.activeBoost = Optional.empty();
            this.boostDuration = 1;
            GTRecipe candidate = boostRecipes.get(boostRecipes.size() - 1);
            if (RecipeHelper.matchRecipe((IRecipeCapabilityHolder)this, (GTRecipe)candidate).isSuccess() && RecipeHelper.handleRecipeIO((IRecipeCapabilityHolder)this, (GTRecipe)candidate, (IO)IO.IN, (Map)this.getRecipeLogic().getChanceCaches()).isSuccess()) {
                this.activeBoost = Optional.of(candidate);
                this.boostDuration = candidate.data.m_128451_(DURATION_KEY);
            }
        }
        ++this.runningTimer;
        this.boostDuration = Math.max(0, this.boostDuration - 1);
        this.lubeDuration = Math.max(0, this.lubeDuration - 1);
        if (this.runningTimer > 72000) {
            this.runningTimer %= 72000;
        }
        return value;
    }

    public boolean regressWhenWaiting() {
        return false;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Generated
    public int getTier() {
        return this.tier;
    }

    static {
        lubricantRecipes.add(GTRecipeBuilder.ofRaw().inputFluids(TFGHelpers.getMaterial("polyalkylene_lubricant").getFluid(1)).addData(LUBRICATION_KEY, 4).addData(DURATION_KEY, 288).buildRawRecipe());
        lubricantRecipes.add(GTRecipeBuilder.ofRaw().inputFluids(GTMaterials.Lubricant.getFluid(1)).addData(LUBRICATION_KEY, 2).addData(DURATION_KEY, 72).buildRawRecipe());
        boostRecipes.add(GTRecipeBuilder.ofRaw().inputFluids(GTMaterials.Oxygen.getFluid(1)).addData(BOOST_KEY, 2).addData(DURATION_KEY, 1).buildRawRecipe());
        boostRecipes.add(GTRecipeBuilder.ofRaw().inputFluids(GTMaterials.Oxygen.getFluid(FluidStorageKeys.LIQUID, 1)).addData(BOOST_KEY, 4).addData(DURATION_KEY, 4).buildRawRecipe());
        boostRecipes.add(GTRecipeBuilder.ofRaw().inputFluids(TFGHelpers.getMaterial("booster_t3").getFluid(1)).addData(BOOST_KEY, 8).addData(DURATION_KEY, 8).buildRawRecipe());
    }
}

