/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.common.data.tfgt.machine.multiblock.electric;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockDisplayText;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableElectricMultiblockMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.common.TFGHelpers;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SMRGenerator2
extends WorkableElectricMultiblockMachine
implements ITieredMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SMRGenerator2.class, WorkableMultiblockMachine.MANAGED_FIELD_HOLDER);
    private long lubricantAmountForDisplay = 0L;
    @DescSynced
    private GTRecipe lastUsedRecipe = null;
    private FluidStack currentLubricant;
    private FluidStack currentBooster;
    private final int tier;
    @DescSynced
    private static final Object2IntMap<FluidStack> lubricantTiers = new Object2IntOpenHashMap();
    @DescSynced
    private static final Object2IntMap<FluidStack> boostingTiers = new Object2IntOpenHashMap();
    private int runningTimer = 0;

    public SMRGenerator2(IMachineBlockEntity holder, int tier) {
        super(holder, new Object[0]);
        this.tier = tier;
    }

    private boolean isIntakesObstructed() {
        Direction dir = this.getFrontFacing();
        boolean mutableXZ = dir.m_122434_() == Direction.Axis.Z;
        BlockPos centerPos = this.getPos().m_121945_(dir);
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                if (x == 0 && y == 0) continue;
                BlockPos blockPos = centerPos.m_7918_(mutableXZ ? x : 0, y, mutableXZ ? 0 : x);
                BlockState blockState = this.getLevel().m_8055_(blockPos);
                if (blockState.m_60795_()) continue;
                return true;
            }
        }
        return false;
    }

    private void updateFluids() {
        if (this.currentBooster != null && this.currentBooster.isEmpty()) {
            this.currentBooster = null;
        }
        if (this.currentLubricant != null && this.currentLubricant.isEmpty()) {
            this.currentLubricant = null;
        }
        List<List> fluidHolders = Objects.requireNonNullElseGet(this.getCapabilitiesFlat(IO.IN, (RecipeCapability)FluidRecipeCapability.CAP), Collections::emptyList).stream().map(container -> container.getContents().stream().filter(FluidStack.class::isInstance).map(FluidStack.class::cast).toList()).filter(container -> !container.isEmpty()).toList();
        this.currentBooster = null;
        this.currentLubricant = null;
        for (List fluidHolder : fluidHolders) {
            for (FluidStack fluidStack : fluidHolder) {
                if (boostingTiers.containsKey((Object)fluidStack)) {
                    if (this.currentBooster != null && boostingTiers.getInt((Object)fluidStack) <= boostingTiers.getInt((Object)this.currentBooster)) continue;
                    this.currentBooster = fluidStack;
                    continue;
                }
                if (!lubricantTiers.containsKey((Object)fluidStack) || this.currentLubricant != null && lubricantTiers.getInt((Object)fluidStack) <= lubricantTiers.getInt((Object)this.currentLubricant)) continue;
                this.currentLubricant = fluidStack;
            }
        }
    }

    public long getOverclockVoltage() {
        return GTValues.V[this.tier];
    }

    public static ModifierFunction recipeModifier(@NotNull MetaMachine machine, @NotNull GTRecipe recipe) {
        if (!(machine instanceof SMRGenerator2)) {
            return RecipeModifier.nullWrongType(SMRGenerator2.class, (MetaMachine)machine);
        }
        SMRGenerator2 engineMachine = (SMRGenerator2)machine;
        long EUt = recipe.getOutputEUt().voltage();
        if (EUt * (long)recipe.duration < 1L) {
            return ModifierFunction.NULL;
        }
        List<List> fluidHolders = Objects.requireNonNullElseGet(engineMachine.getCapabilitiesFlat(IO.IN, (RecipeCapability)FluidRecipeCapability.CAP), Collections::emptyList).stream().map(container -> container.getContents().stream().filter(FluidStack.class::isInstance).map(FluidStack.class::cast).toList()).filter(container -> !container.isEmpty()).toList();
        for (List fluidHolder : fluidHolders) {
            for (FluidStack fluidStack : fluidHolder) {
                if (boostingTiers.containsKey((Object)fluidStack)) {
                    if (engineMachine.currentBooster != null && !engineMachine.currentBooster.isEmpty() && boostingTiers.getInt((Object)fluidStack) <= boostingTiers.getInt((Object)engineMachine.currentBooster)) continue;
                    engineMachine.currentBooster = fluidStack;
                    continue;
                }
                if (!lubricantTiers.containsKey((Object)fluidStack) || engineMachine.currentLubricant != null && !engineMachine.currentLubricant.isEmpty() && lubricantTiers.getInt((Object)fluidStack) <= lubricantTiers.getInt((Object)engineMachine.currentLubricant)) continue;
                engineMachine.currentLubricant = fluidStack;
            }
        }
        if (EUt > 0L && !engineMachine.isIntakesObstructed() && engineMachine.currentLubricant != null && !engineMachine.currentLubricant.isEmpty()) {
            int maxParallel = (int)(engineMachine.getOverclockVoltage() / EUt);
            int actualParallel = ParallelLogic.getParallelAmount((MetaMachine)engineMachine, (GTRecipe)recipe, (int)maxParallel);
            int tier = lubricantTiers.getInt((Object)engineMachine.currentLubricant);
            float durationModifier = (float)lubricantTiers.getInt((Object)engineMachine.currentLubricant) / 2.0f;
            double eutMultiplier = 1.0;
            int consumptionMult = 1;
            if (engineMachine.currentBooster == null || engineMachine.currentBooster.isEmpty()) {
                eutMultiplier = actualParallel;
            } else {
                consumptionMult = boostingTiers.getInt((Object)engineMachine.currentBooster);
                eutMultiplier = actualParallel * (boostingTiers.getInt((Object)engineMachine.currentBooster) * 2);
            }
            return ModifierFunction.builder().inputModifier(ContentModifier.multiplier((double)(consumptionMult * actualParallel))).outputModifier(ContentModifier.multiplier((double)(consumptionMult * actualParallel))).durationMultiplier((double)durationModifier).eutMultiplier(eutMultiplier).parallels(actualParallel).build();
        }
        return ModifierFunction.NULL;
    }

    public boolean onWorking() {
        int tickCycle;
        int consumptionRate;
        this.updateFluids();
        boolean value = super.onWorking();
        GTRecipe recipe = this.recipeLogic.getLastRecipe();
        if (recipe != null) {
            this.lastUsedRecipe = recipe;
        }
        if (this.currentBooster != null && !this.currentBooster.isEmpty()) {
            consumptionRate = -1;
            tickCycle = -1;
            if (this.currentBooster.isFluidEqual(GTMaterials.Oxygen.getFluid(1))) {
                consumptionRate = 1;
                tickCycle = 1;
            } else if (this.currentBooster.isFluidEqual(GTMaterials.Oxygen.getFluid(FluidStorageKeys.LIQUID, 1))) {
                consumptionRate = 4;
                tickCycle = 1;
            } else if (this.currentBooster.isFluidEqual(TFGHelpers.getMaterial("booster_t3").getFluid(1))) {
                consumptionRate = 1;
                tickCycle = 2;
            }
            if (tickCycle != -1 && this.runningTimer % tickCycle == 0 && consumptionRate != -1 && this.currentBooster.getAmount() >= consumptionRate) {
                this.currentBooster.shrink(consumptionRate);
            }
        }
        if (this.currentLubricant != null && !this.currentLubricant.isEmpty()) {
            consumptionRate = -1;
            tickCycle = -1;
            if (this.currentLubricant.containsFluid(GTMaterials.Lubricant.getFluid(1))) {
                tickCycle = 72;
                consumptionRate = 1;
            } else if (this.currentLubricant.containsFluid(TFGHelpers.getMaterial("polyalkylene_lubricant").getFluid(1))) {
                tickCycle = 144;
                consumptionRate = 1;
            } else if (this.currentLubricant.containsFluid(TFGHelpers.getMaterial("uranium_waste").getFluid(1))) {
                tickCycle = 288;
                consumptionRate = 1;
            }
            if (tickCycle != -1 && this.runningTimer % tickCycle == 0) {
                if (consumptionRate != -1 && this.currentLubricant.getAmount() >= consumptionRate) {
                    this.currentLubricant.shrink(consumptionRate);
                } else {
                    this.recipeLogic.interruptRecipe();
                }
            }
        } else if (this.currentLubricant != null) {
            this.recipeLogic.interruptRecipe();
        }
        this.lubricantAmountForDisplay = this.currentLubricant != null && !this.currentLubricant.isEmpty() ? (long)this.currentLubricant.getAmount() : 0L;
        ++this.runningTimer;
        if (this.runningTimer > 72000) {
            this.runningTimer %= 72000;
        }
        return value;
    }

    public boolean regressWhenWaiting() {
        return false;
    }

    public void addDisplayText(List<Component> textList) {
        long boosterAmountForDisplay;
        FluidStack requiredFluid;
        GTRecipe recipe;
        int tier;
        MultiblockDisplayText.Builder builder = MultiblockDisplayText.builder(textList, (boolean)this.isFormed()).setWorkingStatus(this.recipeLogic.isWorkingEnabled(), this.recipeLogic.isActive());
        MutableComponent voltageName = Component.m_237113_((String)GTValues.VNF[GTUtil.getFloorTierByVoltage((long)this.getOverclockVoltage())]);
        int amperageName = 1;
        if (this.currentBooster != null && !this.currentBooster.isEmpty() && (tier = boostingTiers.getInt((Object)this.currentBooster)) > 0) {
            amperageName = tier * 2;
        }
        int amperageNameFinal = amperageName;
        if (this.recipeLogic.isSuspend() && !this.recipeLogic.getFancyTooltip().isEmpty()) {
            builder.addCustom(t -> t.add((Component)this.recipeLogic.getFancyTooltip().get(0)));
            return;
        }
        builder.addCustom(t -> {
            MutableComponent combined = Component.m_237119_();
            MutableComponent prefix = Component.m_237115_((String)"tfg.gui.max_energy_per_tick_amps.prefix").m_130940_(ChatFormatting.WHITE);
            MutableComponent middle = Component.m_237113_((String)(FormattingUtil.formatNumbers((long)(this.getOverclockVoltage() * (long)amperageNameFinal)) + " (" + amperageNameFinal + "A ")).m_130940_(ChatFormatting.GRAY);
            MutableComponent suffix = Component.m_237113_((String)")").m_130940_(ChatFormatting.GRAY);
            combined.m_7220_((Component)prefix).m_7220_((Component)Component.m_237113_((String)" ")).m_7220_((Component)middle).m_7220_((Component)voltageName).m_7220_((Component)suffix);
            t.add(combined);
        });
        if (this.isActive() && this.isWorkingEnabled()) {
            long euOutput = this.recipeLogic.getLastRecipe() != null ? this.recipeLogic.getLastRecipe().getOutputEUt().voltage() : 0L;
            builder.addCustom(t -> {
                MutableComponent text = Component.m_237113_((String)"Energy Output: ").m_130940_(ChatFormatting.WHITE);
                MutableComponent euValue = Component.m_237113_((String)FormattingUtil.formatNumbers((long)euOutput)).m_130940_(ChatFormatting.GREEN);
                MutableComponent unit = Component.m_237113_((String)" EU/t").m_130940_(ChatFormatting.WHITE);
                text.m_7220_((Component)euValue).m_7220_((Component)unit);
                t.add(text);
            });
        }
        if ((recipe = this.lastUsedRecipe) == null) {
            return;
        }
        FluidStack fluidStack = requiredFluid = RecipeHelper.getInputFluids((GTRecipe)recipe).isEmpty() ? FluidStack.EMPTY : (FluidStack)RecipeHelper.getInputFluids((GTRecipe)recipe).get(0);
        if (requiredFluid.isEmpty()) {
            return;
        }
        long EUt = recipe.getOutputEUt().voltage();
        long maxVoltage = this.getMaxVoltage();
        int maxParallel = (int)Math.max(1L, maxVoltage / EUt);
        int actualParallel = ParallelLogic.getParallelAmount((MetaMachine)this, (GTRecipe)recipe, (int)maxParallel);
        int tier2 = 1;
        if (this.currentLubricant != null && !this.currentLubricant.isEmpty()) {
            tier2 = lubricantTiers.getInt((Object)this.currentLubricant);
        }
        float durationMultiplier = (float)tier2 / 2.0f;
        long totalFluid = Math.round((float)(requiredFluid.getAmount() * actualParallel) * 1.0f);
        builder.addCustom(t -> t.add(Component.m_237115_((String)"tfg.gui.consumes").m_7220_((Component)Component.m_237113_((String)(FormattingUtil.formatNumbers((long)totalFluid) + " mB ")).m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237115_((String)"tfg.gui.per_cycle").m_130940_(ChatFormatting.GRAY))));
        int duration = recipe.duration;
        builder.addCustom(t -> {
            double seconds = (double)duration / 20.0;
            t.add(Component.m_237115_((String)"tfg.gui.cycle_duration").m_7220_((Component)Component.m_237113_((String)(duration + " ticks")).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)(" (\u2248" + String.format("%.2f", seconds) + " s)")).m_130940_(ChatFormatting.GREEN)));
        });
        long l = boosterAmountForDisplay = this.currentBooster != null && !this.currentBooster.isEmpty() ? (long)this.currentBooster.getAmount() : 0L;
        if (this.isFormed && this.currentBooster != null && !this.currentBooster.isEmpty()) {
            int tierBooster = boostingTiers.getInt((Object)this.currentBooster);
            int consumptionRate = -1;
            int tickCycle = -1;
            if (this.currentBooster.isFluidEqual(GTMaterials.Oxygen.getFluid(1))) {
                consumptionRate = 1;
                tickCycle = 1;
            } else if (this.currentBooster.isFluidEqual(GTMaterials.Oxygen.getFluid(FluidStorageKeys.LIQUID, 1))) {
                consumptionRate = 4;
                tickCycle = 1;
            } else if (this.currentBooster.isFluidEqual(TFGHelpers.getMaterial("booster_t3").getFluid(1))) {
                consumptionRate = 1;
                tickCycle = 2;
            }
            long totalTicksRemaining = 0L;
            if (consumptionRate > 0 && tickCycle > 0) {
                double mB_per_tick = (double)consumptionRate / (double)tickCycle;
                totalTicksRemaining = (long)((double)boosterAmountForDisplay / mB_per_tick);
            }
            long totalSeconds = totalTicksRemaining / 20L;
            long hours = totalSeconds / 3600L;
            long minutes = totalSeconds % 3600L / 60L;
            String timeFormatted = String.format("%dh %02dm", hours, minutes);
            builder.addCustom(tl -> tl.add(Component.m_237110_((String)"tfg.gui.smr_generator.booster_used", (Object[])new Object[]{Component.m_237115_((String)this.currentBooster.getTranslationKey())}).m_130940_(ChatFormatting.AQUA)));
            builder.addCustom(tl -> tl.add(Component.m_237113_((String)("[Boost: x" + tierBooster + ", Lasts: " + timeFormatted + "]")).m_130940_(ChatFormatting.AQUA)));
        }
        long l2 = this.lubricantAmountForDisplay = this.currentLubricant != null && !this.currentLubricant.isEmpty() ? (long)this.currentLubricant.getAmount() : 0L;
        if (this.isFormed && this.currentLubricant != null && !this.currentLubricant.isEmpty()) {
            int tierLubricant = lubricantTiers.getInt((Object)this.currentLubricant);
            int ticksPerUnit = this.currentLubricant.containsFluid(GTMaterials.Lubricant.getFluid(1)) ? 72 : (this.currentLubricant.containsFluid(TFGHelpers.getMaterial("polyalkylene_lubricant").getFluid(FluidStorageKeys.LIQUID, 1)) ? 288 : 1);
            long totalTicksRemaining = this.lubricantAmountForDisplay * (long)ticksPerUnit;
            long totalSeconds = totalTicksRemaining / 20L;
            long hours = totalSeconds / 3600L;
            long minutes = totalSeconds % 3600L / 60L;
            String timeFormatted = String.format("%dh %02dm", hours, minutes);
            builder.addCustom(tl -> tl.add(Component.m_237110_((String)"tfg.gui.smr_generator.lubricant_used", (Object[])new Object[]{Component.m_237115_((String)this.currentLubricant.getTranslationKey())}).m_130940_(ChatFormatting.YELLOW)));
            builder.addCustom(tl -> tl.add(Component.m_237113_((String)("[Boost: x" + tierLubricant / 2 + ", Lasts: " + timeFormatted + "]")).m_130940_(ChatFormatting.YELLOW)));
        }
        builder.addWorkingStatusLine();
    }

    @Nullable
    public String getRecipeFluidInputInfo() {
        GTRecipe recipe = this.recipeLogic.getLastRecipe();
        if (recipe == null) {
            Iterator iterator = this.recipeLogic.searchRecipe();
            GTRecipe gTRecipe = recipe = iterator != null && iterator.hasNext() ? (GTRecipe)iterator.next() : null;
            if (recipe == null) {
                return null;
            }
        }
        FluidStack requiredFluidInput = (FluidStack)RecipeHelper.getInputFluids((GTRecipe)recipe).get(0);
        long ocAmount = this.getMaxVoltage() / recipe.getOutputEUt().voltage();
        int neededAmount = GTMath.saturatedCast((long)(ocAmount * (long)requiredFluidInput.getAmount()));
        return String.valueOf(ChatFormatting.RED) + FormattingUtil.formatNumbers((int)neededAmount) + "mB";
    }

    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        super.attachTooltips(tooltipsPanel);
        tooltipsPanel.attachTooltips(new IFancyTooltip[]{new IFancyTooltip.Basic(() -> GuiTextures.INDICATOR_NO_STEAM.get(false), () -> List.of(Component.m_237115_((String)"gtceu.multiblock.large_combustion_engine.obstructed").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))), this::isIntakesObstructed, () -> null)});
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Generated
    public int getTier() {
        return this.tier;
    }

    static {
        boostingTiers.put((Object)GTMaterials.Oxygen.getFluid(1), 2);
        boostingTiers.put((Object)GTMaterials.Oxygen.getFluid(FluidStorageKeys.LIQUID, 1), 4);
        boostingTiers.put((Object)TFGHelpers.getMaterial("booster_t3").getFluid(1), 8);
        lubricantTiers.put((Object)GTMaterials.Lubricant.getFluid(1), 2);
        lubricantTiers.put((Object)TFGHelpers.getMaterial("polyalkylene_lubricant").getFluid(1), 4);
    }
}

