/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.compat.emi;

import com.gregtechceu.gtceu.api.data.DimensionMarker;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.registry.EmiTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.Nullable;
import su.terrafirmagreg.core.TFGCore;
import su.terrafirmagreg.core.compat.emi.TFGEmiPlugin;

public class OreVeinInfoRecipe
implements EmiRecipe {
    private final String ID;
    @Nullable
    private final String[] emiInfo;
    private final ResourceLocation dimension;
    private final int rarity;
    private final int minY;
    private final int maxY;
    private final int size;
    private final int height;
    private final int radius;
    private final double density;
    private final String[] rockTypes;
    private final WeightedBlock[] ores;
    private final WeightedItem[] oreItems;

    public OreVeinInfoRecipe(String ID, String dimension, int rarity, double density, int minY, int maxY, int size, int height, int radius, String[] types, WeightedBlock[] blocks, @Nullable String[] emiInfo) {
        this.ID = ID;
        this.dimension = ResourceLocation.parse((String)dimension);
        this.rarity = rarity;
        this.density = density;
        this.minY = minY;
        this.maxY = maxY;
        this.size = size;
        this.height = height;
        this.radius = radius;
        this.rockTypes = types;
        this.ores = blocks;
        this.emiInfo = emiInfo;
        ITagManager tagRegistry = ForgeRegistries.ITEMS.tags();
        if (tagRegistry == null) {
            this.oreItems = new WeightedItem[0];
            return;
        }
        ArrayList<WeightedItem> rawOres = new ArrayList<WeightedItem>();
        for (WeightedBlock ore : this.ores) {
            ArrayList validRawOres = new ArrayList();
            ITag normalTag = tagRegistry.getTag(tagRegistry.createTagKey(ResourceLocation.fromNamespaceAndPath((String)"forge", (String)("raw_materials/" + ore.ore))));
            normalTag.forEach(v -> {
                if (!tagRegistry.getTag(tagRegistry.createTagKey(EmiTags.HIDDEN_FROM_RECIPE_VIEWERS)).contains(v)) {
                    validRawOres.add(v);
                }
            });
            if (validRawOres.isEmpty()) continue;
            rawOres.add(new WeightedItem((Item)validRawOres.get(0), ore.weightPercent));
        }
        this.oreItems = (WeightedItem[])rawOres.toArray(WeightedItem[]::new);
    }

    public EmiRecipeCategory getCategory() {
        return TFGEmiPlugin.ORE_VEIN_INFO;
    }

    @Nullable
    public ResourceLocation getId() {
        return TFGCore.id(this.ID + "_emi");
    }

    public int getDisplayWidth() {
        return 140;
    }

    public int getDisplayHeight() {
        return 180;
    }

    public void addWidgets(WidgetHolder widgets) {
        int offsetY = 0;
        offsetY = this.createLabelWidget(widgets, offsetY);
        offsetY = this.createOreItemWidgets(widgets, offsetY);
        offsetY = this.createVeinInfoText(widgets, offsetY);
        offsetY = this.createRockTypesWidget(widgets, offsetY);
        offsetY = this.createInfoWidget(widgets, offsetY);
        this.createDimensionMarker(widgets, offsetY);
    }

    private int createLabelWidget(WidgetHolder holder, int offsetY) {
        FormattedCharSequence oreVeinLabelComp = Component.m_237115_((String)("ore_vein.tfg." + this.ID)).m_7532_();
        int width = Minecraft.m_91087_().f_91062_.m_92724_(oreVeinLabelComp);
        int offsetX = (this.getDisplayWidth() - width) / 2;
        holder.addText(oreVeinLabelComp, offsetX, 0, 0, false);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return offsetY + 9 + 2;
    }

    private int createOreItemWidgets(WidgetHolder holder, int offsetY) {
        int offsetX = (this.getDisplayWidth() - this.oreItems.length * 20) / 2;
        Font font = Minecraft.m_91087_().f_91062_;
        for (WeightedItem oreItem : this.oreItems) {
            SlotWidget widget = new SlotWidget(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{oreItem.ore}), (long)1L), offsetX + 1, offsetY);
            widget.large(false);
            widget.drawBack(true);
            widget.recipeContext((EmiRecipe)this);
            holder.add((Widget)widget);
            FormattedCharSequence oreChance = Component.m_237113_((String)((oreItem.weightPercent == 0 ? 1 : oreItem.weightPercent) + "%")).m_7532_();
            int textOffset = (20 - font.m_92724_(oreChance)) / 2;
            holder.addText(oreChance, offsetX + textOffset, offsetY + 18, 0, false);
            offsetX += 20;
        }
        Objects.requireNonNull(font);
        return offsetY + 18 + 9 + 5;
    }

    private int createVeinInfoText(WidgetHolder holder, int offsetY) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int lineH = 9;
        holder.addText((Component)Component.m_237110_((String)"tfg.emi.ore_veins.rarity", (Object[])new Object[]{this.rarity}), 2, offsetY, 0, false);
        holder.addText((Component)Component.m_237110_((String)"tfg.emi.ore_veins.density", (Object[])new Object[]{this.density}), 2, offsetY += lineH, 0, false);
        holder.addText((Component)Component.m_237110_((String)"tfg.emi.ore_veins.y_ranges", (Object[])new Object[]{this.minY, this.maxY}), 2, offsetY += lineH, 0, false);
        offsetY += lineH;
        if (this.size != 0) {
            holder.addText((Component)Component.m_237110_((String)"tfg.emi.ore_veins.size", (Object[])new Object[]{this.size}), 2, offsetY, 0, false);
            offsetY += lineH;
        }
        if (this.height != 0) {
            holder.addText((Component)Component.m_237110_((String)"tfg.emi.ore_veins.height", (Object[])new Object[]{this.height}), 2, offsetY, 0, false);
            offsetY += lineH;
        }
        if (this.radius != 0) {
            holder.addText((Component)Component.m_237110_((String)"tfg.emi.ore_veins.radius", (Object[])new Object[]{this.radius}), 2, offsetY, 0, false);
            offsetY += lineH;
        }
        return offsetY;
    }

    private int createRockTypesWidget(WidgetHolder holder, int offsetY) {
        int offsetStart;
        holder.addText((Component)Component.m_237115_((String)"tfg.emi.ore_veins.rock_types"), 2, offsetY, 0, false);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        offsetY += 9;
        int perLine = Math.floorDiv(this.getDisplayWidth(), 18);
        perLine = Math.min(perLine, this.rockTypes.length);
        int offsetX = offsetStart = (this.getDisplayWidth() - perLine * 18) / 2;
        int currentDrawPos = 1;
        for (String rockBlock : this.rockTypes) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.parse((String)rockBlock));
            if (block == null) continue;
            Item blockItem = block.m_5456_();
            if (currentDrawPos > perLine) {
                offsetY += 18;
                currentDrawPos = 1;
                offsetX = offsetStart;
            }
            SlotWidget widget = new SlotWidget(EmiIngredient.of((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{blockItem}), (long)1L), offsetX, offsetY);
            widget.large(false);
            widget.drawBack(true);
            widget.recipeContext((EmiRecipe)this);
            holder.add((Widget)widget);
            offsetX += 18;
            ++currentDrawPos;
        }
        return offsetY;
    }

    private int createInfoWidget(WidgetHolder holder, int offsetY) {
        if (this.emiInfo == null) {
            return offsetY;
        }
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        int lineH = 9;
        offsetY += lineH * 2 + 2;
        for (String part : this.emiInfo) {
            holder.addText((Component)Component.m_237115_((String)part), 2, offsetY, 0, false);
            offsetY += lineH;
        }
        return offsetY + lineH + 2;
    }

    private void createDimensionMarker(WidgetHolder holder, int offsetY) {
        DimensionMarker marker = (DimensionMarker)GTRegistries.DIMENSION_MARKERS.get((Object)this.dimension);
        if (marker == null) {
            return;
        }
        ItemStack icon = marker.getIcon();
        SlotWidget slot = new SlotWidget(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{icon})), this.getDisplayWidth() - 26, this.getDisplayHeight() - 26);
        slot.large(true);
        slot.drawBack(false);
        slot.recipeContext((EmiRecipe)this);
        holder.add((Widget)slot);
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    public List<EmiIngredient> getInputs() {
        return List.of();
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> oreList = new ArrayList<EmiStack>();
        ITagManager tagRegistry = ForgeRegistries.ITEMS.tags();
        if (tagRegistry == null) {
            return oreList;
        }
        for (WeightedBlock ore : this.ores) {
            ITag poorTag = tagRegistry.getTag(tagRegistry.createTagKey(ResourceLocation.fromNamespaceAndPath((String)"forge", (String)("poor_raw_materials/" + ore.ore))));
            ITag normalTag = tagRegistry.getTag(tagRegistry.createTagKey(ResourceLocation.fromNamespaceAndPath((String)"forge", (String)("raw_materials/" + ore.ore))));
            ITag richTag = tagRegistry.getTag(tagRegistry.createTagKey(ResourceLocation.fromNamespaceAndPath((String)"forge", (String)("rich_raw_materials/" + ore.ore))));
            poorTag.forEach(v -> oreList.add(EmiStack.of((ItemLike)v)));
            normalTag.forEach(v -> oreList.add(EmiStack.of((ItemLike)v)));
            richTag.forEach(v -> oreList.add(EmiStack.of((ItemLike)v)));
        }
        return oreList;
    }

    public record WeightedBlock(String ore, int weightPercent) {
    }

    public record WeightedItem(Item ore, int weightPercent) {
    }
}

