/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.mixins.common.ad_astra;

import earth.terrarium.adastra.common.blockentities.machines.OxygenDistributorBlockEntity;
import earth.terrarium.adastra.common.blockentities.machines.OxygenLoaderBlockEntity;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.recipes.machines.OxygenLoadingRecipe;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={OxygenDistributorBlockEntity.class}, remap=false)
public abstract class OxygenDistributorMixin
extends OxygenLoaderBlockEntity {
    @Shadow
    private int shutDownTicks;
    @Final
    @Shadow
    private Set<BlockPos> lastDistributedBlocks;
    @Shadow
    private long energyPerTick;
    @Shadow
    private float fluidPerTick;
    @Shadow
    private int distributedBlocksCount;

    public OxygenDistributorMixin(BlockPos pos, BlockState state, int containerSize, Set<BlockPos> lastDistributedBlocks) {
        super(pos, state, containerSize);
    }

    @Shadow
    protected abstract long calculateFluidPerTick();

    @Shadow
    protected abstract boolean canCraftDistribution(long var1);

    @Shadow
    protected abstract long calculateEnergyPerTick();

    @Shadow
    protected abstract void consumeDistribution(long var1);

    @Shadow
    protected abstract void tickOxygen(ServerLevel var1, BlockPos var2, BlockState var3);

    @Shadow
    protected abstract void clearOxygenBlocks();

    @Overwrite
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        super.serverTick(level, time, state, pos);
        if (this.shutDownTicks > 0) {
            --this.shutDownTicks;
            return;
        }
        long fluidPerTick = this.calculateFluidPerTick();
        boolean canDistribute = this.canCraftDistribution(Math.max(FluidConstants.fromMillibuckets((long)1L), fluidPerTick));
        if (this.canFunction() && canDistribute) {
            this.getEnergyStorage().internalExtract(this.calculateEnergyPerTick(), false);
            this.setLit(true);
            this.consumeDistribution(FluidConstants.fromMillibuckets((long)Math.max(1L, fluidPerTick)));
            if (time % (long)MachineConfig.distributionRefreshRate == 0L) {
                this.tickOxygen(level, pos, state);
            }
            if (time % 200L == 0L) {
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.OXYGEN_OUTTAKE.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
            } else if (time % 100L == 0L) {
                level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.OXYGEN_INTAKE.get(), SoundSource.BLOCKS, 0.2f, 1.0f);
            }
        } else if (!this.lastDistributedBlocks.isEmpty()) {
            this.clearOxygenBlocks();
            this.shutDownTicks = 60;
            this.setLit(false);
        } else if (time % 10L == 0L) {
            this.setLit(false);
        }
        this.energyPerTick = (long)(this.recipe != null && this.canCraft() ? ((OxygenLoadingRecipe)this.recipe).energy() : 0) + (canDistribute ? this.calculateEnergyPerTick() : 0L);
        this.fluidPerTick = canDistribute ? (float)fluidPerTick : 0.0f;
        this.distributedBlocksCount = canDistribute ? this.lastDistributedBlocks.size() : 0;
    }
}

