/*
 * Decompiled with CFR 0.152.
 */
package su.terrafirmagreg.core.network.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import su.terrafirmagreg.core.client.OreHighlightRenderer;

public record OreHighlightPacket(List<BlockPos> positions) {
    public static void encode(OreHighlightPacket pkt, FriendlyByteBuf buf) {
        buf.m_130130_(pkt.positions.size());
        for (BlockPos pos : pkt.positions) {
            buf.m_130064_(pos);
        }
    }

    public static OreHighlightPacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(size);
        for (int i = 0; i < size; ++i) {
            positions.add(buf.m_130135_());
        }
        return new OreHighlightPacket(positions);
    }

    public static void handle(OreHighlightPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> OreHighlightRenderer.addHighlights(pkt.positions));
        ctx.get().setPacketHandled(true);
    }
}

